/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization;

import java.util.UUID;
import java.util.function.Function;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;

public interface UaDecoder {
    public Boolean readBoolean(String var1) throws UaSerializationException;

    public Byte readSByte(String var1) throws UaSerializationException;

    public Short readInt16(String var1) throws UaSerializationException;

    public Integer readInt32(String var1) throws UaSerializationException;

    public Long readInt64(String var1) throws UaSerializationException;

    public UByte readByte(String var1) throws UaSerializationException;

    public UShort readUInt16(String var1) throws UaSerializationException;

    public UInteger readUInt32(String var1) throws UaSerializationException;

    public ULong readUInt64(String var1) throws UaSerializationException;

    public Float readFloat(String var1) throws UaSerializationException;

    public Double readDouble(String var1) throws UaSerializationException;

    public String readString(String var1) throws UaSerializationException;

    public DateTime readDateTime(String var1) throws UaSerializationException;

    public UUID readGuid(String var1) throws UaSerializationException;

    public ByteString readByteString(String var1) throws UaSerializationException;

    public XmlElement readXmlElement(String var1) throws UaSerializationException;

    public NodeId readNodeId(String var1) throws UaSerializationException;

    public ExpandedNodeId readExpandedNodeId(String var1) throws UaSerializationException;

    public StatusCode readStatusCode(String var1) throws UaSerializationException;

    public QualifiedName readQualifiedName(String var1) throws UaSerializationException;

    public LocalizedText readLocalizedText(String var1) throws UaSerializationException;

    public ExtensionObject readExtensionObject(String var1) throws UaSerializationException;

    public DataValue readDataValue(String var1) throws UaSerializationException;

    public Variant readVariant(String var1) throws UaSerializationException;

    public DiagnosticInfo readDiagnosticInfo(String var1) throws UaSerializationException;

    public <T> T[] readArray(String var1, Function<String, T> var2, Class<T> var3) throws UaSerializationException;

    public <T extends UaStructure> T readBuiltinStruct(String var1, Class<T> var2) throws UaSerializationException;

    public <T extends UaStructure> T[] readBuiltinStructArray(String var1, Class<T> var2) throws UaSerializationException;

    public Object readStruct(String var1, NodeId var2) throws UaSerializationException;

    public Object[] readStructArray(String var1, NodeId var2) throws UaSerializationException;

    public UaMessage readMessage(String var1) throws UaSerializationException;
}

