/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization.codecs;

import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaXmlStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaXmlStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaXmlDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDataTypeManager;

public interface SerializationContext {
    public static final SerializationContext INTERNAL = OpcUaDataTypeManager::getInstance;

    public DataTypeManager getTypeManager();

    default public Object decode(String namespaceUri, String description, OpcUaBinaryStreamDecoder decoder) throws UaSerializationException {
        OpcUaBinaryDataTypeCodec<?> codec = this.getTypeManager().getBinaryCodec(namespaceUri, description);
        if (codec == null) {
            throw new UaSerializationException(0x80070000L, String.format("no OpcBinaryDataTypeCodec registered for description=%s under namespaceUri=%s", description, namespaceUri));
        }
        return codec.decode(this, decoder);
    }

    default public Object decode(String namespaceUri, String description, OpcUaXmlStreamDecoder decoder) throws UaSerializationException {
        OpcUaXmlDataTypeCodec<?> codec = this.getTypeManager().getXmlCodec(namespaceUri, description);
        if (codec == null) {
            throw new UaSerializationException(0x80070000L, String.format("no OpcXmlDataTypeCodec registered for description=%s under namespaceUri=%s", description, namespaceUri));
        }
        return codec.decode(this, decoder);
    }

    default public void encode(String namespaceUri, String description, Object value, OpcUaBinaryStreamEncoder encoder) throws UaSerializationException {
        OpcUaBinaryDataTypeCodec<?> codec = this.getTypeManager().getBinaryCodec(namespaceUri, description);
        if (codec == null) {
            throw new UaSerializationException(0x80060000L, String.format("no OpcBinaryDataTypeCodec registered for description=%s under namespaceUri=%s", description, namespaceUri));
        }
        codec.encode(this, value, encoder);
    }

    default public void encode(String namespaceUri, String description, Object value, OpcUaXmlStreamEncoder encoder) throws UaSerializationException {
        OpcUaXmlDataTypeCodec<?> codec = this.getTypeManager().getXmlCodec(namespaceUri, description);
        if (codec == null) {
            throw new UaSerializationException(0x80060000L, String.format("no OpcXmlDataTypeCodec registered for description=%s under namespaceUri=%s", description, namespaceUri));
        }
        codec.encode(this, value, encoder);
    }
}

