/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types;

import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaXmlDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public interface DataTypeManager {
    public void registerTypeDictionary(DataTypeDictionary<?> var1);

    @Nullable
    public DataTypeDictionary getTypeDictionary(String var1);

    @Nullable
    public OpcUaBinaryDataTypeCodec<?> getBinaryCodec(NodeId var1);

    @Nullable
    public OpcUaXmlDataTypeCodec<?> getXmlCodec(NodeId var1);

    @Nullable
    default public DataTypeCodec getCodec(String namespaceUri, String description) {
        DataTypeDictionary dictionary = this.getTypeDictionary(namespaceUri);
        return dictionary != null ? (DataTypeCodec)dictionary.getCodec(description) : null;
    }

    @Nullable
    default public OpcUaBinaryDataTypeCodec<?> getBinaryCodec(String namespaceUri, String description) {
        DataTypeCodec codec = this.getCodec(namespaceUri, description);
        if (codec instanceof OpcUaBinaryDataTypeCodec) {
            return (OpcUaBinaryDataTypeCodec)codec;
        }
        return null;
    }

    @Nullable
    default public OpcUaXmlDataTypeCodec<?> getXmlCodec(String namespaceUri, String description) {
        DataTypeCodec codec = this.getCodec(namespaceUri, description);
        if (codec instanceof OpcUaXmlDataTypeCodec) {
            return (OpcUaXmlDataTypeCodec)codec;
        }
        return null;
    }
}

