/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class OpcUaBinaryDataTypeDictionary
implements DataTypeDictionary<OpcUaBinaryDataTypeCodec<?>> {
    private final String namespaceUri;
    private final Map<String, OpcUaBinaryDataTypeCodec<?>> codecsByDescription;
    private final Map<NodeId, OpcUaBinaryDataTypeCodec<?>> codecsByEncodingId;

    public OpcUaBinaryDataTypeDictionary(String namespaceUri) {
        this.namespaceUri = namespaceUri;
        this.codecsByDescription = Maps.newConcurrentMap();
        this.codecsByEncodingId = Maps.newConcurrentMap();
    }

    public OpcUaBinaryDataTypeDictionary(String namespaceUri, Map<String, OpcUaBinaryDataTypeCodec<?>> byDescription, Map<NodeId, OpcUaBinaryDataTypeCodec<?>> byEncodingId) {
        this.namespaceUri = namespaceUri;
        this.codecsByDescription = Maps.newConcurrentMap();
        this.codecsByDescription.putAll(byDescription);
        this.codecsByEncodingId = Maps.newConcurrentMap();
        this.codecsByEncodingId.putAll(byEncodingId);
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public OpcUaBinaryDataTypeCodec<?> getCodec(String description) {
        return this.codecsByDescription.get(description);
    }

    @Override
    public OpcUaBinaryDataTypeCodec<?> getCodec(NodeId encodingId) {
        return this.codecsByEncodingId.get(encodingId);
    }

    @Override
    public void registerEnumCodec(OpcUaBinaryDataTypeCodec<?> codec, String description) {
        this.codecsByDescription.put(description, codec);
    }

    @Override
    public void registerStructCodec(OpcUaBinaryDataTypeCodec<?> codec, String description, NodeId encodingId) {
        this.codecsByDescription.put(description, codec);
        this.codecsByEncodingId.put(encodingId, codec);
    }

    @Override
    public Map<String, OpcUaBinaryDataTypeCodec<?>> getCodecsByDescription() {
        return this.codecsByDescription;
    }

    @Override
    public Map<NodeId, OpcUaBinaryDataTypeCodec<?>> getCodecsByEncodingId() {
        return this.codecsByEncodingId;
    }
}

