/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaXmlStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaXmlStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaXmlDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.xml.sax.SAXException;

public class OpcUaDataTypeEncoding
implements DataTypeEncoding {
    private final ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;

    @Override
    public ByteString encodeToByteString(Object object, NodeId encodingTypeId, DataTypeManager dataTypeManager) throws UaSerializationException {
        try {
            OpcUaBinaryDataTypeCodec<?> codec = dataTypeManager.getBinaryCodec(encodingTypeId);
            if (codec == null) {
                throw new UaSerializationException(0x80060000L, "no codec registered for encodingTypeId=" + encodingTypeId);
            }
            ByteBuf buffer = this.allocator.buffer().order(ByteOrder.LITTLE_ENDIAN);
            OpcUaBinaryStreamEncoder writer = new OpcUaBinaryStreamEncoder(buffer);
            codec.encode(() -> dataTypeManager, object, writer);
            byte[] bs = new byte[buffer.readableBytes()];
            buffer.readBytes(bs);
            buffer.release();
            return ByteString.of(bs);
        }
        catch (ClassCastException e) {
            throw new UaSerializationException(0x80060000L, (Throwable)e);
        }
    }

    @Override
    public XmlElement encodeToXmlElement(Object object, NodeId encodingTypeId, DataTypeManager dataTypeManager) throws UaSerializationException {
        try {
            OpcUaXmlDataTypeCodec<?> codec = dataTypeManager.getXmlCodec(encodingTypeId);
            if (codec == null) {
                throw new UaSerializationException(0x80060000L, "no codec registered for encodingTypeId=" + encodingTypeId);
            }
            OpcUaXmlStreamEncoder writer = new OpcUaXmlStreamEncoder();
            codec.encode(() -> dataTypeManager, object, writer);
            return new XmlElement(writer.getDocumentXml());
        }
        catch (ClassCastException e) {
            throw new UaSerializationException(0x80060000L, (Throwable)e);
        }
    }

    @Override
    public Object decodeFromByteString(ByteString encoded, NodeId encodingTypeId, DataTypeManager dataTypeManager) throws UaSerializationException {
        try {
            OpcUaBinaryDataTypeCodec<?> codec = dataTypeManager.getBinaryCodec(encodingTypeId);
            if (codec == null) {
                throw new UaSerializationException(0x80070000L, "no codec registered for encodingTypeId=" + encodingTypeId);
            }
            byte[] bs = encoded.bytes();
            if (bs == null) {
                bs = new byte[]{};
            }
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])bs).order(ByteOrder.LITTLE_ENDIAN);
            OpcUaBinaryStreamDecoder reader = new OpcUaBinaryStreamDecoder(buffer);
            return codec.decode(() -> dataTypeManager, reader);
        }
        catch (ClassCastException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }

    @Override
    public Object decodeFromXmlElement(XmlElement encoded, NodeId encodingTypeId, DataTypeManager dataTypeManager) throws UaSerializationException {
        try {
            OpcUaXmlDataTypeCodec<?> codec = dataTypeManager.getXmlCodec(encodingTypeId);
            if (codec == null) {
                throw new UaSerializationException(0x80070000L, "no codec registered for encodingTypeId=" + encodingTypeId);
            }
            OpcUaXmlStreamDecoder reader = new OpcUaXmlStreamDecoder();
            reader.setInput(new ByteArrayInputStream(encoded.getFragment().getBytes()));
            return reader.readStruct(null, encodingTypeId);
        }
        catch (IOException | SAXException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }
}

