/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaXmlDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.BuiltinDataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.DataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class OpcUaDataTypeManager
implements DataTypeManager {
    public static final String BINARY_NAMESPACE_URI = "http://opcfoundation.org/UA/";
    public static final String XML_NAMESPACE_URI = "http://opcfoundation.org/UA/2008/02/Types.xsd";
    private final ConcurrentMap<String, DataTypeDictionary<?>> dictionaries = Maps.newConcurrentMap();
    private final ConcurrentMap<NodeId, DataTypeCodec> codecs = Maps.newConcurrentMap();

    public static OpcUaDataTypeManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private OpcUaDataTypeManager() {
        this.registerTypeDictionary(BuiltinDataTypeDictionary.getBinaryInstance());
        this.registerTypeDictionary(BuiltinDataTypeDictionary.getXmlInstance());
    }

    @Override
    public void registerTypeDictionary(DataTypeDictionary<?> dataTypeDictionary) {
        this.dictionaries.put(dataTypeDictionary.getNamespaceUri(), dataTypeDictionary);
        this.codecs.putAll(dataTypeDictionary.getCodecsByEncodingId());
    }

    @Override
    @Nullable
    public DataTypeDictionary getTypeDictionary(String namespaceUri) {
        return (DataTypeDictionary)this.dictionaries.get(namespaceUri);
    }

    @Override
    @Nullable
    public OpcUaBinaryDataTypeCodec<?> getBinaryCodec(NodeId encodingId) {
        DataTypeCodec codec = (DataTypeCodec)this.codecs.get(encodingId);
        if (codec instanceof OpcUaBinaryDataTypeCodec) {
            return (OpcUaBinaryDataTypeCodec)codec;
        }
        return null;
    }

    @Override
    @Nullable
    public OpcUaXmlDataTypeCodec<?> getXmlCodec(NodeId encodingId) {
        DataTypeCodec codec = (DataTypeCodec)this.codecs.get(encodingId);
        if (codec instanceof OpcUaXmlDataTypeCodec) {
            return (OpcUaXmlDataTypeCodec)codec;
        }
        return null;
    }

    private static class InstanceHolder {
        private static final OpcUaDataTypeManager INSTANCE = new OpcUaDataTypeManager();

        private InstanceHolder() {
        }
    }
}

