/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;

public final class DataValue {
    private final Variant value;
    private final StatusCode status;
    private final DateTime sourceTime;
    private final UShort sourcePicoseconds;
    private final DateTime serverTime;
    private final UShort serverPicoseconds;

    public DataValue(long statusCode) {
        this(new StatusCode(statusCode));
    }

    public DataValue(StatusCode statusCode) {
        this(Variant.NULL_VALUE, statusCode, DateTime.MIN_VALUE);
    }

    public DataValue(Variant value) {
        this(value, StatusCode.GOOD);
    }

    public DataValue(Variant value, StatusCode status) {
        this(value, status, DateTime.now());
    }

    public DataValue(Variant value, StatusCode status, @Nullable DateTime time) {
        this(value, status, time, time);
    }

    public DataValue(Variant value, StatusCode status, @Nullable DateTime sourceTime, @Nullable DateTime serverTime) {
        this(value, status, sourceTime, null, serverTime, null);
    }

    public DataValue(Variant value, StatusCode status, @Nullable DateTime sourceTime, @Nullable UShort sourcePicoseconds, @Nullable DateTime serverTime, @Nullable UShort serverPicoseconds) {
        this.value = value;
        this.status = status;
        this.sourceTime = sourceTime;
        this.sourcePicoseconds = sourcePicoseconds;
        this.serverTime = serverTime;
        this.serverPicoseconds = serverPicoseconds;
    }

    public Variant getValue() {
        return this.value;
    }

    public StatusCode getStatusCode() {
        return this.status;
    }

    @Nullable
    public DateTime getSourceTime() {
        return this.sourceTime;
    }

    @Nullable
    public UShort getSourcePicoseconds() {
        return this.sourcePicoseconds;
    }

    @Nullable
    public DateTime getServerTime() {
        return this.serverTime;
    }

    @Nullable
    public UShort getServerPicoseconds() {
        return this.serverPicoseconds;
    }

    public DataValue withStatus(StatusCode status) {
        return new DataValue(this.value, status, this.sourceTime, this.serverTime);
    }

    public DataValue withSourceTime(@Nullable DateTime sourceTime) {
        return new DataValue(this.value, this.status, sourceTime, this.serverTime);
    }

    public DataValue withServerTime(@Nullable DateTime serverTime) {
        return new DataValue(this.value, this.status, this.sourceTime, serverTime);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.add("value", (Object)this.value);
        helper.add("status", (Object)this.status);
        if (this.sourceTime != null) {
            helper.add("sourceTime", (Object)this.sourceTime);
        }
        if (this.sourcePicoseconds != null) {
            helper.add("sourcePicoseconds", (Object)this.sourcePicoseconds);
        }
        if (this.serverTime != null) {
            helper.add("serverTime", (Object)this.serverTime);
        }
        if (this.serverPicoseconds != null) {
            helper.add("serverPicoseconds", (Object)this.serverPicoseconds);
        }
        return helper.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataValue dataValue = (DataValue)o;
        return Objects.equals(this.value, dataValue.value) && Objects.equals(this.status, dataValue.status) && Objects.equals(this.sourceTime, dataValue.sourceTime) && Objects.equals(this.sourcePicoseconds, dataValue.sourcePicoseconds) && Objects.equals(this.serverTime, dataValue.serverTime) && Objects.equals(this.serverPicoseconds, dataValue.serverPicoseconds);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.status, this.sourceTime, this.sourcePicoseconds, this.serverTime, this.serverPicoseconds);
    }

    public static DataValue derivedValue(DataValue from, TimestampsToReturn timestamps) {
        boolean includeSource = timestamps == TimestampsToReturn.Source || timestamps == TimestampsToReturn.Both;
        boolean includeServer = timestamps == TimestampsToReturn.Server || timestamps == TimestampsToReturn.Both;
        return new DataValue(from.value, from.status, includeSource ? from.sourceTime : null, includeServer ? new DateTime() : null);
    }

    public static DataValue derivedNonValue(DataValue from, TimestampsToReturn timestamps) {
        boolean includeServer = timestamps == TimestampsToReturn.Server || timestamps == TimestampsToReturn.Both;
        return new DataValue(from.value, from.status, null, includeServer ? new DateTime() : null);
    }

    public static DataValue valueOnly(Variant v) {
        return new DataValue(v, null, null, null);
    }
}

