/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum ExceptionDeviationFormat implements UaEnumeration
{
    AbsoluteValue(0),
    PercentOfValue(1),
    PercentOfRange(2),
    PercentOfEURange(3),
    Unknown(4);

    private final int value;
    private static final ImmutableMap<Integer, ExceptionDeviationFormat> VALUES;

    private ExceptionDeviationFormat(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static ExceptionDeviationFormat from(Integer value) {
        if (value == null) {
            return null;
        }
        return (ExceptionDeviationFormat)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(ExceptionDeviationFormat exceptionDeviationFormat, UaEncoder encoder) {
        encoder.writeInt32(null, exceptionDeviationFormat.getValue());
    }

    public static ExceptionDeviationFormat decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (ExceptionDeviationFormat)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ExceptionDeviationFormat e : ExceptionDeviationFormat.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

