/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum FilterOperator implements UaEnumeration
{
    Equals(0),
    IsNull(1),
    GreaterThan(2),
    LessThan(3),
    GreaterThanOrEqual(4),
    LessThanOrEqual(5),
    Like(6),
    Not(7),
    Between(8),
    InList(9),
    And(10),
    Or(11),
    Cast(12),
    InView(13),
    OfType(14),
    RelatedTo(15),
    BitwiseAnd(16),
    BitwiseOr(17);

    private final int value;
    private static final ImmutableMap<Integer, FilterOperator> VALUES;

    private FilterOperator(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static FilterOperator from(Integer value) {
        if (value == null) {
            return null;
        }
        return (FilterOperator)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(FilterOperator filterOperator, UaEncoder encoder) {
        encoder.writeInt32(null, filterOperator.getValue());
    }

    public static FilterOperator decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (FilterOperator)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (FilterOperator e : FilterOperator.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

