/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum IdType implements UaEnumeration
{
    Numeric(0),
    String(1),
    Guid(2),
    Opaque(3);

    private final int value;
    private static final ImmutableMap<Integer, IdType> VALUES;

    private IdType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static IdType from(Integer value) {
        if (value == null) {
            return null;
        }
        return (IdType)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(IdType idType, UaEncoder encoder) {
        encoder.writeInt32(null, idType.getValue());
    }

    public static IdType decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (IdType)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (IdType e : IdType.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

