/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum NamingRuleType implements UaEnumeration
{
    Mandatory(1),
    Optional(2),
    Constraint(3);

    private final int value;
    private static final ImmutableMap<Integer, NamingRuleType> VALUES;

    private NamingRuleType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static NamingRuleType from(Integer value) {
        if (value == null) {
            return null;
        }
        return (NamingRuleType)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(NamingRuleType namingRuleType, UaEncoder encoder) {
        encoder.writeInt32(null, namingRuleType.getValue());
    }

    public static NamingRuleType decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (NamingRuleType)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (NamingRuleType e : NamingRuleType.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

