/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ApplicationType;

public class ApplicationDescription
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ApplicationDescription;
    public static final NodeId BinaryEncodingId = Identifiers.ApplicationDescription_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ApplicationDescription_Encoding_DefaultXml;
    protected final String applicationUri;
    protected final String productUri;
    protected final LocalizedText applicationName;
    protected final ApplicationType applicationType;
    protected final String gatewayServerUri;
    protected final String discoveryProfileUri;
    protected final String[] discoveryUrls;

    public ApplicationDescription() {
        this.applicationUri = null;
        this.productUri = null;
        this.applicationName = null;
        this.applicationType = null;
        this.gatewayServerUri = null;
        this.discoveryProfileUri = null;
        this.discoveryUrls = null;
    }

    public ApplicationDescription(String applicationUri, String productUri, LocalizedText applicationName, ApplicationType applicationType, String gatewayServerUri, String discoveryProfileUri, String[] discoveryUrls) {
        this.applicationUri = applicationUri;
        this.productUri = productUri;
        this.applicationName = applicationName;
        this.applicationType = applicationType;
        this.gatewayServerUri = gatewayServerUri;
        this.discoveryProfileUri = discoveryProfileUri;
        this.discoveryUrls = discoveryUrls;
    }

    public String getApplicationUri() {
        return this.applicationUri;
    }

    public String getProductUri() {
        return this.productUri;
    }

    public LocalizedText getApplicationName() {
        return this.applicationName;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public String getGatewayServerUri() {
        return this.gatewayServerUri;
    }

    public String getDiscoveryProfileUri() {
        return this.discoveryProfileUri;
    }

    @Nullable
    public String[] getDiscoveryUrls() {
        return this.discoveryUrls;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ApplicationUri", (Object)this.applicationUri).add("ProductUri", (Object)this.productUri).add("ApplicationName", (Object)this.applicationName).add("ApplicationType", (Object)this.applicationType).add("GatewayServerUri", (Object)this.gatewayServerUri).add("DiscoveryProfileUri", (Object)this.discoveryProfileUri).add("DiscoveryUrls", (Object)this.discoveryUrls).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ApplicationDescription> {
        @Override
        public Class<ApplicationDescription> getType() {
            return ApplicationDescription.class;
        }

        @Override
        public ApplicationDescription decode(UaDecoder decoder) throws UaSerializationException {
            String applicationUri = decoder.readString("ApplicationUri");
            String productUri = decoder.readString("ProductUri");
            LocalizedText applicationName = decoder.readLocalizedText("ApplicationName");
            ApplicationType applicationType = ApplicationType.from(decoder.readInt32("ApplicationType"));
            String gatewayServerUri = decoder.readString("GatewayServerUri");
            String discoveryProfileUri = decoder.readString("DiscoveryProfileUri");
            String[] discoveryUrls = decoder.readArray("DiscoveryUrls", decoder::readString, String.class);
            return new ApplicationDescription(applicationUri, productUri, applicationName, applicationType, gatewayServerUri, discoveryProfileUri, discoveryUrls);
        }

        @Override
        public void encode(ApplicationDescription value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeString("ApplicationUri", value.applicationUri);
            encoder.writeString("ProductUri", value.productUri);
            encoder.writeLocalizedText("ApplicationName", value.applicationName);
            encoder.writeInt32("ApplicationType", value.applicationType != null ? value.applicationType.getValue() : 0);
            encoder.writeString("GatewayServerUri", value.gatewayServerUri);
            encoder.writeString("DiscoveryProfileUri", value.discoveryProfileUri);
            encoder.writeArray("DiscoveryUrls", value.discoveryUrls, encoder::writeString);
        }
    }
}

