/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterElement;

public class ContentFilter
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ContentFilter;
    public static final NodeId BinaryEncodingId = Identifiers.ContentFilter_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ContentFilter_Encoding_DefaultXml;
    protected final ContentFilterElement[] elements;

    public ContentFilter() {
        this.elements = null;
    }

    public ContentFilter(ContentFilterElement[] elements) {
        this.elements = elements;
    }

    @Nullable
    public ContentFilterElement[] getElements() {
        return this.elements;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Elements", (Object)this.elements).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ContentFilter> {
        @Override
        public Class<ContentFilter> getType() {
            return ContentFilter.class;
        }

        @Override
        public ContentFilter decode(UaDecoder decoder) throws UaSerializationException {
            ContentFilterElement[] elements = (ContentFilterElement[])decoder.readBuiltinStructArray("Elements", ContentFilterElement.class);
            return new ContentFilter(elements);
        }

        @Override
        public void encode(ContentFilter value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStructArray("Elements", value.elements, ContentFilterElement.class);
        }
    }
}

