/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryDataDescription;

public class NodeTypeDescription
implements UaStructure {
    public static final NodeId TypeId = Identifiers.NodeTypeDescription;
    public static final NodeId BinaryEncodingId = Identifiers.NodeTypeDescription_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.NodeTypeDescription_Encoding_DefaultXml;
    protected final ExpandedNodeId typeDefinitionNode;
    protected final Boolean includeSubTypes;
    protected final QueryDataDescription[] dataToReturn;

    public NodeTypeDescription() {
        this.typeDefinitionNode = null;
        this.includeSubTypes = null;
        this.dataToReturn = null;
    }

    public NodeTypeDescription(ExpandedNodeId typeDefinitionNode, Boolean includeSubTypes, QueryDataDescription[] dataToReturn) {
        this.typeDefinitionNode = typeDefinitionNode;
        this.includeSubTypes = includeSubTypes;
        this.dataToReturn = dataToReturn;
    }

    public ExpandedNodeId getTypeDefinitionNode() {
        return this.typeDefinitionNode;
    }

    public Boolean getIncludeSubTypes() {
        return this.includeSubTypes;
    }

    @Nullable
    public QueryDataDescription[] getDataToReturn() {
        return this.dataToReturn;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("TypeDefinitionNode", (Object)this.typeDefinitionNode).add("IncludeSubTypes", (Object)this.includeSubTypes).add("DataToReturn", (Object)this.dataToReturn).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<NodeTypeDescription> {
        @Override
        public Class<NodeTypeDescription> getType() {
            return NodeTypeDescription.class;
        }

        @Override
        public NodeTypeDescription decode(UaDecoder decoder) throws UaSerializationException {
            ExpandedNodeId typeDefinitionNode = decoder.readExpandedNodeId("TypeDefinitionNode");
            Boolean includeSubTypes = decoder.readBoolean("IncludeSubTypes");
            QueryDataDescription[] dataToReturn = (QueryDataDescription[])decoder.readBuiltinStructArray("DataToReturn", QueryDataDescription.class);
            return new NodeTypeDescription(typeDefinitionNode, includeSubTypes, dataToReturn);
        }

        @Override
        public void encode(NodeTypeDescription value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeExpandedNodeId("TypeDefinitionNode", value.typeDefinitionNode);
            encoder.writeBoolean("IncludeSubTypes", value.includeSubTypes);
            encoder.writeBuiltinStructArray("DataToReturn", value.dataToReturn, QueryDataDescription.class);
        }
    }
}

