/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;

public class ReadEventDetails
extends HistoryReadDetails {
    public static final NodeId TypeId = Identifiers.ReadEventDetails;
    public static final NodeId BinaryEncodingId = Identifiers.ReadEventDetails_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ReadEventDetails_Encoding_DefaultXml;
    protected final UInteger numValuesPerNode;
    protected final DateTime startTime;
    protected final DateTime endTime;
    protected final EventFilter filter;

    public ReadEventDetails() {
        this.numValuesPerNode = null;
        this.startTime = null;
        this.endTime = null;
        this.filter = null;
    }

    public ReadEventDetails(UInteger numValuesPerNode, DateTime startTime, DateTime endTime, EventFilter filter) {
        this.numValuesPerNode = numValuesPerNode;
        this.startTime = startTime;
        this.endTime = endTime;
        this.filter = filter;
    }

    public UInteger getNumValuesPerNode() {
        return this.numValuesPerNode;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public EventFilter getFilter() {
        return this.filter;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("NumValuesPerNode", (Object)this.numValuesPerNode).add("StartTime", (Object)this.startTime).add("EndTime", (Object)this.endTime).add("Filter", (Object)this.filter).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ReadEventDetails> {
        @Override
        public Class<ReadEventDetails> getType() {
            return ReadEventDetails.class;
        }

        @Override
        public ReadEventDetails decode(UaDecoder decoder) throws UaSerializationException {
            UInteger numValuesPerNode = decoder.readUInt32("NumValuesPerNode");
            DateTime startTime = decoder.readDateTime("StartTime");
            DateTime endTime = decoder.readDateTime("EndTime");
            EventFilter filter = decoder.readBuiltinStruct("Filter", EventFilter.class);
            return new ReadEventDetails(numValuesPerNode, startTime, endTime, filter);
        }

        @Override
        public void encode(ReadEventDetails value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeUInt32("NumValuesPerNode", value.numValuesPerNode);
            encoder.writeDateTime("StartTime", value.startTime);
            encoder.writeDateTime("EndTime", value.endTime);
            encoder.writeBuiltinStruct("Filter", value.filter, EventFilter.class);
        }
    }
}

