/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;

public class ReadRawModifiedDetails
extends HistoryReadDetails {
    public static final NodeId TypeId = Identifiers.ReadRawModifiedDetails;
    public static final NodeId BinaryEncodingId = Identifiers.ReadRawModifiedDetails_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ReadRawModifiedDetails_Encoding_DefaultXml;
    protected final Boolean isReadModified;
    protected final DateTime startTime;
    protected final DateTime endTime;
    protected final UInteger numValuesPerNode;
    protected final Boolean returnBounds;

    public ReadRawModifiedDetails() {
        this.isReadModified = null;
        this.startTime = null;
        this.endTime = null;
        this.numValuesPerNode = null;
        this.returnBounds = null;
    }

    public ReadRawModifiedDetails(Boolean isReadModified, DateTime startTime, DateTime endTime, UInteger numValuesPerNode, Boolean returnBounds) {
        this.isReadModified = isReadModified;
        this.startTime = startTime;
        this.endTime = endTime;
        this.numValuesPerNode = numValuesPerNode;
        this.returnBounds = returnBounds;
    }

    public Boolean getIsReadModified() {
        return this.isReadModified;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public UInteger getNumValuesPerNode() {
        return this.numValuesPerNode;
    }

    public Boolean getReturnBounds() {
        return this.returnBounds;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("IsReadModified", (Object)this.isReadModified).add("StartTime", (Object)this.startTime).add("EndTime", (Object)this.endTime).add("NumValuesPerNode", (Object)this.numValuesPerNode).add("ReturnBounds", (Object)this.returnBounds).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ReadRawModifiedDetails> {
        @Override
        public Class<ReadRawModifiedDetails> getType() {
            return ReadRawModifiedDetails.class;
        }

        @Override
        public ReadRawModifiedDetails decode(UaDecoder decoder) throws UaSerializationException {
            Boolean isReadModified = decoder.readBoolean("IsReadModified");
            DateTime startTime = decoder.readDateTime("StartTime");
            DateTime endTime = decoder.readDateTime("EndTime");
            UInteger numValuesPerNode = decoder.readUInt32("NumValuesPerNode");
            Boolean returnBounds = decoder.readBoolean("ReturnBounds");
            return new ReadRawModifiedDetails(isReadModified, startTime, endTime, numValuesPerNode, returnBounds);
        }

        @Override
        public void encode(ReadRawModifiedDetails value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBoolean("IsReadModified", value.isReadModified);
            encoder.writeDateTime("StartTime", value.startTime);
            encoder.writeDateTime("EndTime", value.endTime);
            encoder.writeUInt32("NumValuesPerNode", value.numValuesPerNode);
            encoder.writeBoolean("ReturnBounds", value.returnBounds);
        }
    }
}

