/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class ResponseHeader
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ResponseHeader;
    public static final NodeId BinaryEncodingId = Identifiers.ResponseHeader_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ResponseHeader_Encoding_DefaultXml;
    protected final DateTime timestamp;
    protected final UInteger requestHandle;
    protected final StatusCode serviceResult;
    protected final DiagnosticInfo serviceDiagnostics;
    protected final String[] stringTable;
    protected final ExtensionObject additionalHeader;

    public ResponseHeader() {
        this.timestamp = null;
        this.requestHandle = null;
        this.serviceResult = null;
        this.serviceDiagnostics = null;
        this.stringTable = null;
        this.additionalHeader = null;
    }

    public ResponseHeader(DateTime timestamp, UInteger requestHandle, StatusCode serviceResult, DiagnosticInfo serviceDiagnostics, String[] stringTable, ExtensionObject additionalHeader) {
        this.timestamp = timestamp;
        this.requestHandle = requestHandle;
        this.serviceResult = serviceResult;
        this.serviceDiagnostics = serviceDiagnostics;
        this.stringTable = stringTable;
        this.additionalHeader = additionalHeader;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public UInteger getRequestHandle() {
        return this.requestHandle;
    }

    public StatusCode getServiceResult() {
        return this.serviceResult;
    }

    public DiagnosticInfo getServiceDiagnostics() {
        return this.serviceDiagnostics;
    }

    @Nullable
    public String[] getStringTable() {
        return this.stringTable;
    }

    public ExtensionObject getAdditionalHeader() {
        return this.additionalHeader;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Timestamp", (Object)this.timestamp).add("RequestHandle", (Object)this.requestHandle).add("ServiceResult", (Object)this.serviceResult).add("ServiceDiagnostics", (Object)this.serviceDiagnostics).add("StringTable", (Object)this.stringTable).add("AdditionalHeader", (Object)this.additionalHeader).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ResponseHeader> {
        @Override
        public Class<ResponseHeader> getType() {
            return ResponseHeader.class;
        }

        @Override
        public ResponseHeader decode(UaDecoder decoder) throws UaSerializationException {
            DateTime timestamp = decoder.readDateTime("Timestamp");
            UInteger requestHandle = decoder.readUInt32("RequestHandle");
            StatusCode serviceResult = decoder.readStatusCode("ServiceResult");
            DiagnosticInfo serviceDiagnostics = decoder.readDiagnosticInfo("ServiceDiagnostics");
            String[] stringTable = decoder.readArray("StringTable", decoder::readString, String.class);
            ExtensionObject additionalHeader = decoder.readExtensionObject("AdditionalHeader");
            return new ResponseHeader(timestamp, requestHandle, serviceResult, serviceDiagnostics, stringTable, additionalHeader);
        }

        @Override
        public void encode(ResponseHeader value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeDateTime("Timestamp", value.timestamp);
            encoder.writeUInt32("RequestHandle", value.requestHandle);
            encoder.writeStatusCode("ServiceResult", value.serviceResult);
            encoder.writeDiagnosticInfo("ServiceDiagnostics", value.serviceDiagnostics);
            encoder.writeArray("StringTable", value.stringTable, encoder::writeString);
            encoder.writeExtensionObject("AdditionalHeader", value.additionalHeader);
        }
    }
}

