/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.InstanceNode;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceNode;

public class ViewNode
extends InstanceNode {
    public static final NodeId TypeId = Identifiers.ViewNode;
    public static final NodeId BinaryEncodingId = Identifiers.ViewNode_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ViewNode_Encoding_DefaultXml;
    protected final Boolean containsNoLoops;
    protected final UByte eventNotifier;

    public ViewNode() {
        super(null, null, null, null, null, null, null, null);
        this.containsNoLoops = null;
        this.eventNotifier = null;
    }

    public ViewNode(NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, ReferenceNode[] references, Boolean containsNoLoops, UByte eventNotifier) {
        super(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references);
        this.containsNoLoops = containsNoLoops;
        this.eventNotifier = eventNotifier;
    }

    public Boolean getContainsNoLoops() {
        return this.containsNoLoops;
    }

    public UByte getEventNotifier() {
        return this.eventNotifier;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("NodeId", (Object)this.nodeId).add("NodeClass", (Object)this.nodeClass).add("BrowseName", (Object)this.browseName).add("DisplayName", (Object)this.displayName).add("Description", (Object)this.description).add("WriteMask", (Object)this.writeMask).add("UserWriteMask", (Object)this.userWriteMask).add("References", (Object)this.references).add("ContainsNoLoops", (Object)this.containsNoLoops).add("EventNotifier", (Object)this.eventNotifier).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ViewNode> {
        @Override
        public Class<ViewNode> getType() {
            return ViewNode.class;
        }

        @Override
        public ViewNode decode(UaDecoder decoder) throws UaSerializationException {
            NodeId nodeId = decoder.readNodeId("NodeId");
            NodeClass nodeClass = NodeClass.from(decoder.readInt32("NodeClass"));
            QualifiedName browseName = decoder.readQualifiedName("BrowseName");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            ReferenceNode[] references = (ReferenceNode[])decoder.readBuiltinStructArray("References", ReferenceNode.class);
            Boolean containsNoLoops = decoder.readBoolean("ContainsNoLoops");
            UByte eventNotifier = decoder.readByte("EventNotifier");
            return new ViewNode(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references, containsNoLoops, eventNotifier);
        }

        @Override
        public void encode(ViewNode value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeNodeId("NodeId", value.nodeId);
            encoder.writeInt32("NodeClass", value.nodeClass != null ? value.nodeClass.getValue() : 0);
            encoder.writeQualifiedName("BrowseName", value.browseName);
            encoder.writeLocalizedText("DisplayName", value.displayName);
            encoder.writeLocalizedText("Description", value.description);
            encoder.writeUInt32("WriteMask", value.writeMask);
            encoder.writeUInt32("UserWriteMask", value.userWriteMask);
            encoder.writeBuiltinStructArray("References", value.references, ReferenceNode.class);
            encoder.writeBoolean("ContainsNoLoops", value.containsNoLoops);
            encoder.writeByte("EventNotifier", value.eventNotifier);
        }
    }
}

