/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateGenerator {
    private static final String KEY_TOOL_CLASS_NAME = "sun.security.tools.keytool.Main";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String keyStoreType;
    private final String certificateAlias;
    private final String certificatePassword;
    private static final SecurityManager SYSTEM_SECURITY_MANAGER = System.getSecurityManager();

    public CertificateGenerator(String keyStorePath, String keyStorePassword, String keyStoreType, String certificateAlias, String certificatePassword) {
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        this.certificateAlias = certificateAlias;
        this.certificatePassword = certificatePassword;
    }

    public X509Certificate generateSelfSignedCertificate(String commonName, String organizationName, String localityName, String stateName, String country, String applicationUri, List<String> dnsNames, List<String> ipAddresses) throws Exception {
        return this.generateSelfSignedCertificate(commonName, "", organizationName, localityName, stateName, country, 365, applicationUri, dnsNames, ipAddresses);
    }

    public X509Certificate generateSelfSignedCertificate(String commonName, String organizationUnit, String organizationName, String localityName, String stateName, String country, int validity, String applicationUri, List<String> dnsNames, List<String> ipAddresses) throws Exception {
        String subject = String.format("cn=%s, ou=%s, o=%s, l=%s, st=%s, c=%s", commonName, organizationUnit, organizationName, localityName, stateName, country);
        List<String> args = this.buildKeyToolArgs(subject, validity, applicationUri, dnsNames, ipAddresses);
        this.invokeKeyTool(args.toArray(new String[args.size()]));
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        try (FileInputStream fis = new FileInputStream(new File(this.keyStorePath));){
            keyStore.load(fis, this.keyStorePassword.toCharArray());
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(this.certificateAlias);
            return x509Certificate;
        }
    }

    private List<String> buildKeyToolArgs(String subject, int validity, String applicationUri, List<String> dnsNames, List<String> ipAddresses) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-selfcert");
        args.add("-genkey");
        args.add("-validity");
        args.add(String.valueOf(validity));
        args.add("-ext");
        args.add("BC=ca:false");
        args.add("-ext");
        args.add("KeyUsage=digitalSignature,nonRepudiation,keyEncipherment,dataEncipherment,keyCertSign");
        args.add("-ext");
        args.add("ExtendedKeyUsage=clientAuth,serverAuth");
        args.add("-ext");
        StringBuilder sb = new StringBuilder();
        sb.append("SubjectAlternativeName=URI:").append(applicationUri);
        for (String dnsName : dnsNames) {
            sb.append(",DNS:").append(dnsName);
        }
        for (String ipAddress : ipAddresses) {
            sb.append(",IP:").append(ipAddress);
        }
        args.add(sb.toString());
        args.add("-keystore");
        args.add(String.format("%s", this.keyStorePath));
        args.add("-storetype");
        args.add(this.keyStoreType);
        args.add("-storepass");
        args.add(String.format("%s", this.keyStorePassword));
        args.add("-keyalg");
        args.add("RSA");
        args.add("-keysize");
        args.add("2048");
        args.add("-alias");
        args.add(String.format("%s", this.certificateAlias));
        args.add("-keypass");
        args.add(String.format("%s", this.certificatePassword));
        args.add("-dname");
        args.add(String.format("%s", subject));
        return args;
    }

    private void invokeKeyTool(String[] args) throws Exception {
        try {
            this.logger.debug("keytool args: {}", (Object)Arrays.toString(args));
            CertificateGenerator.disableSystemExitCall();
            Class<?> c = Class.forName(KEY_TOOL_CLASS_NAME);
            Method m = c.getMethod("main", String[].class);
            m.invoke(null, new Object[]{args});
        }
        catch (Throwable t) {
            throw new Exception("error invoking keytool", t);
        }
        finally {
            CertificateGenerator.enableSystemExitCall();
        }
    }

    private static synchronized void disableSystemExitCall() {
        SecurityManager securityManager = new SecurityManager(){

            @Override
            public void checkPermission(Permission permission) {
                if (permission.getName().startsWith("exitVM")) {
                    throw new ExitTrappedException();
                }
            }
        };
        System.setSecurityManager(securityManager);
    }

    private static synchronized void enableSystemExitCall() {
        System.setSecurityManager(SYSTEM_SECURITY_MANAGER);
    }

    private static class ExitTrappedException
    extends SecurityException {
        private ExitTrappedException() {
        }
    }
}

