/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.net.URI;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointUtil.class);

    public static String getPath(@Nonnull String endpointUrl) {
        try {
            URI uri = new URI(endpointUrl).parseServerAuthority();
            String path = uri.getPath();
            if (path == null || path.isEmpty()) {
                path = "/";
            } else if (path.length() > 1 && path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            return path;
        }
        catch (Throwable e) {
            LOGGER.warn("Endpoint URL '{}' is not a valid URI: {}", (Object)e.getMessage(), (Object)e);
            return endpointUrl;
        }
    }
}

