/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.util.ArrayDeque;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionQueue {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Object queueLock = new Object();
    private final ArrayDeque<Runnable> queue = new ArrayDeque();
    private volatile boolean pollSubmitted = false;
    private volatile boolean paused = false;
    private final ExecutorService service;

    public ExecutionQueue(ExecutorService service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Runnable runnable) {
        Object object = this.queueLock;
        synchronized (object) {
            this.queue.add(runnable);
            this.maybeSubmitPoll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitToHead(Runnable runnable) {
        Object object = this.queueLock;
        synchronized (object) {
            this.queue.addFirst(runnable);
            this.maybeSubmitPoll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.queueLock;
        synchronized (object) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.queueLock;
        synchronized (object) {
            this.paused = false;
            this.maybeSubmitPoll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeSubmitPoll() {
        Object object = this.queueLock;
        synchronized (object) {
            if (!(this.pollSubmitted || this.paused || this.queue.isEmpty())) {
                this.service.submit(new PollAndExecute());
                this.pollSubmitted = true;
            }
        }
    }

    private class PollAndExecute
    implements Runnable {
        private PollAndExecute() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable runnable;
            Object object = ExecutionQueue.this.queueLock;
            synchronized (object) {
                runnable = (Runnable)ExecutionQueue.this.queue.poll();
            }
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                ExecutionQueue.this.log.warn("Uncaught Throwable during execution.", throwable);
            }
            object = ExecutionQueue.this.queueLock;
            synchronized (object) {
                if (ExecutionQueue.this.queue.isEmpty() || ExecutionQueue.this.paused) {
                    ExecutionQueue.this.pollSubmitted = false;
                } else {
                    ExecutionQueue.this.service.submit(new PollAndExecute());
                }
            }
        }
    }
}

