/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum Architecture {
    NOARCH(0, "noarch"),
    INTEL(1, "athlon, geode, pentium3, pentium4, i386, i486, i586, i686, x86_64, amd64, ia32e, em64t"),
    ALPHA(2, "alpha, alphaev5, alphaev56, alphapca56, alphaev6, alphaev67"),
    SPARC(3, "sparc, sun4, sun4c, sun4d, sun4m, sparcv8, sparcv9, sparcv9v"),
    MIPS(4, "mips"),
    PPC(5, "ppc, ppc8260, ppc8560, ppc32dy4, ppciseries, ppcpseries"),
    M86K(6, "m68k"),
    IP(7, "sgi"),
    RS6000(8, "rs6000"),
    IA64(9, "ia64"),
    MIPSEL(11, "mipsel"),
    ARM(12, "armv3l, armv4b, armv4l, armv5tel, armv5tejl, armv6l, armv6hl, armv7l, armv7hl"),
    M86KMINT(13, "m68kmint, atarist, atariste, ataritt, falcon, atariclone, milan, hades"),
    S390(14, "s390, i370"),
    S390X(15, "s390x"),
    PPC64(16, "ppc64, ppc64iseries, ppc64pseries, ppc64p7"),
    SH(17, "sh, sh3, sh4, sh4a"),
    XTENSA(18, "xtensa"),
    AARCH64(19, "aarch64");

    private static final Map<Integer, Architecture> MAP;
    private static final Map<String, Architecture> ALTMAP;
    private short value;
    private String aliases;

    private static String getAliases(Architecture arch) {
        return System.getProperty(Architecture.class.getPackage().getName() + ".arch." + arch.name(), arch.aliases);
    }

    private Architecture(short value, String aliases) {
        this.value = value;
        this.aliases = aliases;
    }

    public short getValue() {
        return this.value;
    }

    public static Optional<Architecture> fromValue(int value) {
        return Optional.ofNullable(MAP.get(value));
    }

    public static Optional<Architecture> fromAlias(String alias) {
        if (alias == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(ALTMAP.get(alias.toLowerCase()));
    }

    static {
        MAP = new HashMap<Integer, Architecture>();
        ALTMAP = new HashMap<String, Architecture>();
        for (Architecture arch : Architecture.values()) {
            MAP.put(Integer.valueOf(arch.value), arch);
            ALTMAP.put(arch.name().toLowerCase(), arch);
            for (String alias : Architecture.getAliases(arch).split(",\\s")) {
                ALTMAP.put(alias.toLowerCase(), arch);
            }
        }
    }
}

