/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum OperatingSystem {
    UNKNOWN(0, "unknown"),
    LINUX(1, "Linux"),
    IRIX(2, "Irix"),
    SUNOS_5(3, "solaris, SunOS5"),
    SUNOS_4(4, "SunOS, SunOS4"),
    AIX(5, "AIX, AmigaOS"),
    HP_UX(6, "hpux10, HP-UX"),
    OSF(7, "OSF1, osf1, osf4.0, osf3.2"),
    FREEBSD(8, "FreeBSD"),
    IRIX64(10, "Irix64"),
    NEXTSTEP(11, "NextStep"),
    BSD(12, "BSD_OS, bsdi"),
    MACHTEN(13, "machten"),
    CYGWIN32_NT(14, "cygwin32"),
    CYGWIN32_95(15, ""),
    UNIX_SV(16, "MP_RAS"),
    MINT(17, "MiNT, FreeMiNT"),
    OS_390(18, "OS/390"),
    VM_ESA(19, "VM/ESA, Linux/ESA"),
    LINUX_390(20, "Linux/390, Linux/ESA"),
    MACOS_X(21, "darwin, macosx");

    private static final Map<Integer, OperatingSystem> MAP;
    private static final Map<String, OperatingSystem> ALTMAP;
    private short value;
    private String aliases;

    private static String getAliases(OperatingSystem os) {
        return System.getProperty(OperatingSystem.class.getPackage().getName() + ".os." + os.name(), os.aliases);
    }

    private OperatingSystem(short value, String aliases) {
        this.value = value;
        this.aliases = aliases;
    }

    public short getValue() {
        return this.value;
    }

    public static Optional<OperatingSystem> fromValue(int value) {
        return Optional.ofNullable(MAP.get(value));
    }

    public static Optional<OperatingSystem> fromAlias(String alias) {
        if (alias == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(ALTMAP.get(alias.toLowerCase()));
    }

    static {
        MAP = new HashMap<Integer, OperatingSystem>();
        ALTMAP = new HashMap<String, OperatingSystem>();
        for (OperatingSystem os : OperatingSystem.values()) {
            MAP.put(Integer.valueOf(os.value), os);
            ALTMAP.put(os.name().toLowerCase(), os);
            for (String alias : OperatingSystem.getAliases(os).split(",\\s")) {
                ALTMAP.put(alias.toLowerCase(), os);
            }
        }
    }
}

