/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;

public class Rpms {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();
    public static final byte[] LEAD_MAGIC = new byte[]{-19, -85, -18, -37};
    public static final byte[] HEADER_MAGIC = new byte[]{-114, -83, -24};
    public static final byte[] EMPTY_128 = new byte[128];
    public static final int IMMUTABLE_TAG_SIGNATURE = 62;
    public static final int IMMUTABLE_TAG_HEADER = 63;

    public static String toHex(byte[] data) {
        return Rpms.toHex(data, Integer.MAX_VALUE);
    }

    public static String toHex(byte[] data, int maxWidth) {
        return Rpms.toHex(data, 0, data.length, maxWidth);
    }

    public static String toHex(byte[] data, int offset, int length, int maxWidth) {
        StringBuilder sb = new StringBuilder(length * 2);
        int lc = 0;
        for (int i = 0; i < length; ++i) {
            if (maxWidth > 0 && lc >= maxWidth) {
                sb.append(System.lineSeparator());
                lc = 0;
            }
            int b = data[offset + i] & 0xFF;
            sb.append(HEX[b >>> 4]);
            sb.append(HEX[b & 0xF]);
            ++lc;
        }
        return sb.toString();
    }

    public static String dumpValue(Object value) {
        StringBuilder sb = new StringBuilder();
        Rpms.dumpValue(sb, value);
        return sb.toString();
    }

    static void writeByteBuffer(OutputStream stream, ByteBuffer dataStore) throws IOException {
        WritableByteChannel c = Channels.newChannel(stream);
        while (dataStore.hasRemaining()) {
            c.write(dataStore);
        }
    }

    public static void dumpValue(StringBuilder sb, Object value) {
        if (value != null) {
            if (value instanceof byte[]) {
                sb.append(Rpms.toHex((byte[])value, -1));
            } else if (value.getClass().isArray()) {
                sb.append(Arrays.toString((Object[])value));
            } else {
                sb.append(value);
            }
        } else {
            sb.append("null");
        }
    }

    public static int padding(int offset) {
        int rem = offset % 8;
        if (rem > 0) {
            return 8 - rem;
        }
        return 0;
    }

    static {
        Arrays.fill(EMPTY_128, (byte)0);
    }
}

