/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm.parse;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.eclipse.packagedrone.utils.rpm.Rpms;

public class HeaderValue {
    public static final Unknown UNKNOWN = new Unknown();
    private final int tag;
    private Object value;
    private final int type;
    private final int index;
    private final int count;

    public HeaderValue(int tag, int type, int index, int count) {
        this.tag = tag;
        this.type = type;
        this.index = index;
        this.count = count;
    }

    public int getTag() {
        return this.tag;
    }

    public Object getValue() {
        return this.value;
    }

    public int getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public int getIndex() {
        return this.index;
    }

    void fillFromStore(ByteBuffer storeData) throws IOException {
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                this.value = this.getFromStore(storeData, true, buf -> Character.valueOf((char)storeData.get()), size -> new Character[size.intValue()]);
                break;
            }
            case 2: {
                this.value = this.getFromStore(storeData, true, buf -> buf.get(), size -> new Byte[size.intValue()]);
                break;
            }
            case 3: {
                this.value = this.getFromStore(storeData, true, buf -> buf.getShort(), size -> new Short[size.intValue()]);
                break;
            }
            case 4: {
                this.value = this.getFromStore(storeData, true, buf -> buf.getInt(), size -> new Integer[size.intValue()]);
                break;
            }
            case 5: {
                this.value = this.getFromStore(storeData, true, buf -> buf.getLong(), size -> new Long[size.intValue()]);
                break;
            }
            case 6: {
                storeData.position(this.index);
                this.value = HeaderValue.makeString(storeData);
                break;
            }
            case 7: {
                byte[] data = new byte[this.count];
                storeData.position(this.index);
                storeData.get(data);
                this.value = data;
                break;
            }
            case 8: {
                this.value = this.getFromStore(storeData, false, buf -> HeaderValue.makeString(buf), size -> new String[size.intValue()]);
                break;
            }
            case 9: {
                this.value = this.getFromStore(storeData, false, buf -> HeaderValue.makeString(buf), size -> new String[size.intValue()]);
                break;
            }
            default: {
                this.value = UNKNOWN;
            }
        }
    }

    private <R> Object getFromStore(ByteBuffer data, boolean collapse, IOFunction<ByteBuffer, R> func, Function<Integer, R[]> creator) throws IOException {
        data.position(this.index);
        if (this.count == 1 && collapse) {
            return func.apply(data);
        }
        R[] result = creator.apply(this.count);
        for (int i = 0; i < this.count; ++i) {
            result[i] = func.apply(data);
        }
        return result;
    }

    private static String makeString(ByteBuffer buf) throws IOException {
        byte[] data = buf.array();
        int start = buf.position();
        for (int i = 0; i < buf.remaining(); ++i) {
            if (data[start + i] != 0) continue;
            buf.position(start + i + 1);
            return new String(data, start, i, StandardCharsets.UTF_8);
        }
        throw new IOException("Corrupt tag entry. Null byte missing!");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.tag);
        sb.append(" = ");
        Rpms.dumpValue(sb, this.value);
        sb.append(" - ").append(this.type).append(" = ");
        if (this.value != null) {
            if (this.value != UNKNOWN) {
                sb.append(this.value.getClass().getName());
            } else {
                sb.append(this.type);
            }
        } else {
            sb.append("NULL");
        }
        sb.append(" # ");
        sb.append(this.count);
        sb.append(']');
        return sb.toString();
    }

    @FunctionalInterface
    public static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }

    private static final class Unknown {
        private Unknown() {
        }

        public String toString() {
            return "UNKNOWN";
        }
    }
}

