/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm.parse;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.packagedrone.utils.rpm.ReadableHeader;
import org.eclipse.packagedrone.utils.rpm.RpmBaseTag;
import org.eclipse.packagedrone.utils.rpm.parse.HeaderValue;

public class InputHeader<T extends RpmBaseTag>
implements ReadableHeader<T> {
    private final Map<Integer, HeaderValue> entries;
    private final long start;
    private final long length;

    public InputHeader(HeaderValue[] entries, long start, long length) {
        LinkedHashMap<Integer, HeaderValue> tags = new LinkedHashMap<Integer, HeaderValue>(entries.length);
        for (HeaderValue entry : entries) {
            tags.put(entry.getTag(), entry);
        }
        this.entries = Collections.unmodifiableMap(tags);
        this.start = start;
        this.length = length;
    }

    public long getStart() {
        return this.start;
    }

    public long getLength() {
        return this.length;
    }

    public Object getTag(T tag) {
        return this.getTagOrDefault(tag, null);
    }

    public Object getTag(int tag) {
        return this.getTagOrDefault(tag, (Object)null);
    }

    @Override
    public Optional<Object> getValue(T tag) {
        return Optional.ofNullable(this.getTag(tag));
    }

    public Optional<Object> getOptionalTag(T tag) {
        return this.getEntry(tag).map(HeaderValue::getValue);
    }

    public Optional<Object> getOptionalTag(int tag) {
        return this.getEntry(tag).map(HeaderValue::getValue);
    }

    public Optional<HeaderValue> getEntry(T tag) {
        return Optional.ofNullable(this.entries.get(tag.getValue()));
    }

    public Optional<HeaderValue> getEntry(int tag) {
        return Optional.ofNullable(this.entries.get(tag));
    }

    public Object getTagOrDefault(T tag, Object defaultValue) {
        return this.getOptionalTag(tag).orElse(defaultValue);
    }

    public Object getTagOrDefault(int tag, Object defaultValue) {
        return this.getOptionalTag(tag).orElse(defaultValue);
    }

    public Map<Integer, HeaderValue> getRawTags() {
        return this.entries;
    }
}

