/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils;

import java.util.concurrent.Callable;
import java.util.function.Function;

public class Exceptions {
    public static <T> T wrapException(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void wrapException(ThrowingRunnable run) {
        Exceptions.wrapException(() -> {
            run.run();
            return null;
        });
    }

    public static <T> T wrapException(Callable<T> callable, Function<Exception, RuntimeException> func) {
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            RuntimeException t = func.apply(e);
            if (t == null) {
                t = new RuntimeException(e);
            } else {
                t.setStackTrace(Thread.currentThread().getStackTrace());
            }
            throw t;
        }
    }

    public static void wrapException(ThrowingRunnable run, Function<Exception, RuntimeException> func) {
        Exceptions.wrapException(() -> {
            run.run();
            return null;
        }, func);
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

