/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class Filters {
    public static String join(List<? extends Node> nodes, String oper) {
        LinkedList<String> s = new LinkedList<String>();
        for (Node node : nodes) {
            String f;
            if (node == null || (f = node.toString()).isEmpty()) continue;
            s.add(f);
        }
        if (s == null || s.isEmpty()) {
            return "";
        }
        if (s.size() == 1) {
            return (String)s.get(0);
        }
        StringBuilder builder = new StringBuilder();
        builder.append('(').append(oper);
        for (String tok : s) {
            builder.append(tok);
        }
        builder.append(')');
        return builder.toString();
    }

    public static String or(List<? extends Node> nodes) {
        return Filters.join(nodes, "|");
    }

    public static String and(List<? extends Node> nodes) {
        return Filters.join(nodes, "&");
    }

    public static String and(Node ... nodes) {
        return Filters.and(Arrays.asList(nodes));
    }

    public static String or(Node ... nodes) {
        return Filters.or(Arrays.asList(nodes));
    }

    public static Node pair(String key, String value) {
        if (value == null) {
            return null;
        }
        return new Pair(key, value);
    }

    public static Node pair(String key, String value, String operator) {
        if (value == null) {
            return null;
        }
        return new Pair(key, value, operator);
    }

    public static Node negate(Node node) {
        if (node == null) {
            return null;
        }
        return new Negate(node);
    }

    private static String version(Version version) {
        if (version == null) {
            return null;
        }
        return version.toString();
    }

    public static Node versionRange(String name, VersionRange versionRange) {
        if (versionRange == null) {
            return null;
        }
        LinkedList<Node> nodes = new LinkedList<Node>();
        if (versionRange.getLeft() != null) {
            if (versionRange.getLeftType() == '(') {
                Filters.add(nodes, Filters.pair(name, Filters.version(versionRange.getLeft()), ">"));
            } else if (versionRange.getLeftType() == '[') {
                Filters.add(nodes, Filters.pair(name, Filters.version(versionRange.getLeft()), ">="));
            }
        }
        if (versionRange.getRight() != null) {
            if (versionRange.getRightType() == ')') {
                Filters.add(nodes, Filters.negate(Filters.pair(name, Filters.version(versionRange.getRight()), ">=")));
            } else if (versionRange.getRightType() == ']') {
                Filters.add(nodes, Filters.pair(name, Filters.version(versionRange.getRight()), "<="));
            }
        }
        if (nodes.isEmpty()) {
            return null;
        }
        return new Multi("&", nodes);
    }

    private static void add(List<Node> nodes, Node node) {
        if (node != null) {
            nodes.add(node);
        }
    }

    public static class Negate
    implements Node {
        private final Node child;

        public Negate(Node node) {
            this.child = node;
        }

        public Node getChild() {
            return this.child;
        }

        public String toString() {
            return "(!" + this.child.toString() + ")";
        }
    }

    public static class Pair
    implements Node {
        private final String key;
        private final String value;
        private final String operator;

        public Pair(String key, String value) {
            this.key = key;
            this.value = value;
            this.operator = "=";
        }

        public Pair(String key, String value, String operator) {
            this.key = key;
            this.value = value;
            this.operator = operator;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "(" + this.key + this.operator + this.value + ")";
        }
    }

    public static class Multi
    implements Node {
        private final String operator;
        private final List<Node> nodes;

        public Multi(String operator) {
            this.operator = operator;
            this.nodes = new LinkedList<Node>();
        }

        private Multi(String operator, List<Node> nodes) {
            this.operator = operator;
            this.nodes = nodes;
        }

        public void addNode(Node node) {
            this.nodes.add(node);
        }

        public String toString() {
            return Filters.join(this.nodes, this.operator);
        }
    }

    public static interface Node {
    }
}

