/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.build;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public enum DigestAlgorithm {
    MD5("MD5", 1),
    SHA1("SHA", 2),
    RIPEMD160("RIPE-MD160", 3),
    DOUBLE_SHA("Double-SHA", 4),
    MD2("MD2", 5),
    TIGER_192("Tiger-192", 6),
    HAVAL_5_160("Haval-5-160", 7),
    SHA256("SHA-256", 8),
    SHA384("SHA-384", 9),
    SHA512("SHA-512", 10),
    SHA224("SHA-224", 11);

    private final String algorithm;
    private final int tag;

    private DigestAlgorithm(String algorithm, int tag) {
        this.algorithm = algorithm;
        this.tag = tag;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public int getTag() {
        return this.tag;
    }

    public static DigestAlgorithm fromTag(int tag) throws IOException {
        for (DigestAlgorithm digestAlgorithm : DigestAlgorithm.values()) {
            if (tag != digestAlgorithm.getTag()) continue;
            return digestAlgorithm;
        }
        throw new IOException(String.format("Unknown tag: %d", tag));
    }

    public MessageDigest createDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(this.getAlgorithm());
    }
}

