/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.coding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.eclipse.packager.rpm.coding.PayloadCodingProvider;
import org.eclipse.packager.rpm.deps.Dependency;

public class GzipPayloadCoding
implements PayloadCodingProvider {
    protected GzipPayloadCoding() {
    }

    @Override
    public String getCoding() {
        return "gzip";
    }

    @Override
    public void fillRequirements(Consumer<Dependency> requirementsConsumer) {
    }

    @Override
    public InputStream createInputStream(InputStream in) throws IOException {
        return new GzipCompressorInputStream(in);
    }

    @Override
    public OutputStream createOutputStream(OutputStream out, Optional<String> optionalFlags) throws IOException {
        String flags;
        int compressionLevel = optionalFlags.isPresent() && (flags = optionalFlags.get()).length() > 0 ? Integer.parseInt(flags.substring(0, 1)) : 9;
        GzipParameters parameters = new GzipParameters();
        parameters.setCompressionLevel(compressionLevel);
        return new GzipCompressorOutputStream(out, parameters);
    }
}

