/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.info;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.eclipse.packager.rpm.RpmSignatureTag;
import org.eclipse.packager.rpm.RpmTag;
import org.eclipse.packager.rpm.RpmTagValue;
import org.eclipse.packager.rpm.info.RpmInformation;
import org.eclipse.packager.rpm.parse.InputHeader;
import org.eclipse.packager.rpm.parse.RpmInputStream;

public final class RpmInformations {
    private RpmInformations() {
    }

    public static RpmInformation makeInformation(RpmInputStream in) throws IOException {
        CpioArchiveEntry cpioEntry;
        InputHeader<RpmTag> header = in.getPayloadHeader();
        InputHeader<RpmSignatureTag> signature = in.getSignatureHeader();
        RpmInformation result = new RpmInformation();
        result.setHeaderStart(header.getStart());
        result.setHeaderEnd(header.getStart() + header.getLength());
        result.setName(RpmInformations.asString(header.getTag(RpmTag.NAME)));
        result.setArchitecture(RpmInformations.asString(header.getTag(RpmTag.ARCH)));
        result.setSummary(RpmInformations.asString(header.getTag(RpmTag.SUMMARY)));
        result.setDescription(RpmInformations.asString(header.getTag(RpmTag.DESCRIPTION)));
        result.setPackager(RpmInformations.asString(header.getTag(RpmTag.PACKAGER)));
        result.setUrl(RpmInformations.asString(header.getTag(RpmTag.URL)));
        result.setLicense(RpmInformations.asString(header.getTag(RpmTag.LICENSE)));
        result.setVendor(RpmInformations.asString(header.getTag(RpmTag.VENDOR)));
        result.setGroup(RpmInformations.asString(header.getTag(RpmTag.GROUP)));
        result.setBuildHost(RpmInformations.asString(header.getTag(RpmTag.BUILDHOST)));
        result.setBuildTimestamp(RpmInformations.asLong(header.getTag(RpmTag.BUILDTIME)));
        result.setSourcePackage(RpmInformations.asString(header.getTag(RpmTag.SOURCE_PACKAGE)));
        result.setInstalledSize(RpmInformations.asLong(header.getTag(RpmTag.SIZE)));
        result.setArchiveSize(RpmInformations.asLong(header.getTag(RpmTag.ARCHIVE_SIZE)));
        if (result.getArchiveSize() == null) {
            result.setArchiveSize(RpmInformations.asLong(signature.getTag(RpmSignatureTag.PAYLOAD_SIZE)));
        }
        RpmInformation.Version ver = new RpmInformation.Version(RpmInformations.asString(header.getTag(RpmTag.VERSION)), RpmInformations.asString(header.getTag(RpmTag.RELEASE)), RpmInformations.asString(header.getTag(RpmTag.EPOCH)));
        result.setVersion(ver);
        Object val = header.getTag(RpmTag.CHANGELOG_TIMESTAMP);
        if (val instanceof Long[]) {
            Long[] ts = (Long[])val;
            String[] authors = (String[])header.getTag(RpmTag.CHANGELOG_AUTHOR);
            String[] texts = (String[])header.getTag(RpmTag.CHANGELOG_TEXT);
            ArrayList<RpmInformation.Changelog> changes = new ArrayList<RpmInformation.Changelog>(ts.length);
            for (int i = 0; i < ts.length; ++i) {
                changes.add(new RpmInformation.Changelog(ts[i], authors[i], texts[i]));
            }
            Collections.sort(changes, Comparator.comparingLong(RpmInformation.Changelog::getTimestamp));
            result.setChangelog(changes);
        }
        result.setProvides(RpmInformations.makeDependencies(header, RpmTag.PROVIDE_NAME, RpmTag.PROVIDE_VERSION, RpmTag.PROVIDE_FLAGS));
        result.setRequires(RpmInformations.makeDependencies(header, RpmTag.REQUIRE_NAME, RpmTag.REQUIRE_VERSION, RpmTag.REQUIRE_FLAGS));
        result.setConflicts(RpmInformations.makeDependencies(header, RpmTag.CONFLICT_NAME, RpmTag.CONFLICT_VERSION, RpmTag.CONFLICT_FLAGS));
        result.setObsoletes(RpmInformations.makeDependencies(header, RpmTag.OBSOLETE_NAME, RpmTag.OBSOLETE_VERSION, RpmTag.OBSOLETE_FLAGS));
        CpioArchiveInputStream cpio = in.getCpioStream();
        while ((cpioEntry = cpio.getNextEntry()) != null) {
            String name = RpmInformations.normalize(cpioEntry.getName());
            if (cpioEntry.isRegularFile()) {
                result.getFiles().add(name);
                continue;
            }
            if (!cpioEntry.isDirectory()) continue;
            result.getDirectories().add(name);
        }
        cpio.close();
        return result;
    }

    public static List<RpmInformation.Dependency> makeDependencies(InputHeader<RpmTag> header, RpmTag namesTag, RpmTag versionsTag, RpmTag flagsTag) {
        String[] namesVal = header.getTag(namesTag);
        String[] versionsVal = header.getTag(versionsTag);
        Long[] flagsVal = header.getTag(flagsTag);
        if (namesVal == null || !(namesVal instanceof String[])) {
            if (namesVal instanceof String) {
                namesVal = new String[]{(String)namesVal};
            } else {
                return Collections.emptyList();
            }
        }
        if (versionsVal != null && !(versionsVal instanceof String[])) {
            if (versionsVal instanceof String) {
                versionsVal = new String[]{(String)versionsVal};
            } else {
                throw new IllegalStateException(String.format("Invalid dependencies version format [%s]: %s", versionsTag, versionsVal));
            }
        }
        if (flagsVal != null && !(flagsVal instanceof Long[])) {
            if (flagsVal instanceof Long) {
                flagsVal = new Long[]{(Long)flagsVal};
            } else if (flagsVal instanceof Integer) {
                flagsVal = new Long[]{((Integer)flagsVal).longValue()};
            } else if (flagsVal instanceof Integer[]) {
                flagsVal = Arrays.stream((Integer[])flagsVal).map(Integer::longValue).toArray(Long[]::new);
            } else {
                throw new IllegalStateException(String.format("Invalid dependencies flags format [%s]: %s", flagsTag, flagsVal));
            }
        }
        String[] names = namesVal;
        String[] versions = versionsVal;
        Long[] flags = flagsVal;
        if (versions != null && names.length != versions.length) {
            throw new IllegalStateException(String.format("Invalid size of dependency versions array [%s] - expected: %s, actual: %s", versionsTag, names.length, versions.length));
        }
        if (flags != null && names.length != flags.length) {
            throw new IllegalStateException(String.format("Invalid size of dependency flags array [%s] - expected: %s, actual: %s", flagsTag, names.length, flags.length));
        }
        ArrayList<RpmInformation.Dependency> result = new ArrayList<RpmInformation.Dependency>(names.length);
        HashSet<String> known = new HashSet<String>();
        for (int i = 0; i < names.length; ++i) {
            String version;
            String name = names[i];
            String string = version = versions != null ? versions[i] : null;
            if (version != null && version.isEmpty()) {
                version = null;
            }
            Long flag = flags != null ? flags[i] : null;
            String key = name;
            if (!known.add(key)) continue;
            result.add(new RpmInformation.Dependency(name, version, flag != null ? flag : 0L));
        }
        return result;
    }

    public static String normalize(String name) {
        if (name.startsWith("./")) {
            return name.substring(1);
        }
        return name;
    }

    public static String asString(Object value) {
        if (value == null) {
            return null;
        }
        return new RpmTagValue(value).asString().orElse(null);
    }

    public static Long asLong(Object value) {
        if (value == null) {
            return null;
        }
        return new RpmTagValue(value).asLong().orElse(null);
    }
}

