/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import java.lang.instrument.IllegalClassFormatException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.weaving.ClassDetails;
import org.eclipse.persistence.internal.jpa.weaving.ClassWeaver;
import org.eclipse.persistence.internal.jpa.weaving.ComputeClassWriter;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.commons.SerialVersionUIDAdder;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderFromCurrentThread;
import org.eclipse.persistence.internal.weaving.WeaverLogger;
import org.eclipse.persistence.sessions.Session;

public class PersistenceWeaver
implements ClassTransformer {
    public static final String EXCEPTION_WHILE_WEAVING = "exception_while_weaving";
    protected Session session;
    protected Map classDetailsMap;

    public PersistenceWeaver(Session session, Map classDetailsMap) {
        this.session = session;
        this.classDetailsMap = classDetailsMap;
    }

    public void clear() {
        this.session = null;
        this.classDetailsMap = null;
    }

    public Map getClassDetailsMap() {
        return this.classDetailsMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        boolean shouldLogFinest;
        block30: {
            shouldLogFinest = WeaverLogger.shouldLog(1);
            Map classDetailsMap = this.classDetailsMap;
            Session session = this.session;
            if (classDetailsMap == null || session == null) {
                return null;
            }
            try {
                ClassDetails classDetails = (ClassDetails)classDetailsMap.get(Helper.toSlashedClassName(className));
                if (classDetails != null) {
                    ClassLoader contextClassLoader;
                    if (shouldLogFinest) {
                        WeaverLogger.log(1, "begin_weaving_class", className);
                    }
                    ClassReader classReader = new ClassReader(classfileBuffer);
                    ClassWriter classWriter = null;
                    String introspectForHierarchy = System.getProperty("eclipselink.weaving.reflective-introspection", null);
                    if (introspectForHierarchy != null) {
                        if (shouldLogFinest) {
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    contextClassLoader = AccessController.doPrivileged(new PrivilegedGetClassLoaderFromCurrentThread());
                                }
                                catch (PrivilegedActionException ex) {
                                    throw (RuntimeException)ex.getCause();
                                }
                            } else {
                                contextClassLoader = Thread.currentThread().getContextClassLoader();
                            }
                            WeaverLogger.log(1, "weaving_init_class_writer", className, Integer.toHexString(System.identityHashCode(contextClassLoader)));
                        }
                        classWriter = new ClassWriter(2);
                    } else {
                        if (shouldLogFinest) {
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    contextClassLoader = AccessController.doPrivileged(new PrivilegedGetClassLoaderFromCurrentThread());
                                }
                                catch (PrivilegedActionException ex) {
                                    throw (RuntimeException)ex.getCause();
                                }
                            } else {
                                contextClassLoader = Thread.currentThread().getContextClassLoader();
                            }
                            WeaverLogger.log(1, "weaving_init_compute_class_writer", className, Integer.toHexString(System.identityHashCode(contextClassLoader)), loader != null ? Integer.toHexString(System.identityHashCode(loader)) : "null");
                        }
                        classWriter = new ComputeClassWriter(loader, 2);
                    }
                    ClassWeaver classWeaver = new ClassWeaver(classWriter, classDetails);
                    SerialVersionUIDAdder sv = new SerialVersionUIDAdder(classWeaver);
                    classReader.accept(sv, 0);
                    if (classWeaver.alreadyWeaved) {
                        if (shouldLogFinest) {
                            WeaverLogger.log(1, "end_weaving_class", className);
                        }
                        return null;
                    }
                    if (classWeaver.weaved) {
                        byte[] bytes = classWriter.toByteArray();
                        String outputPath = System.getProperty("eclipselink.weaving.output.path", "");
                        if (!outputPath.equals("")) {
                            Helper.outputClassFile(className, bytes, outputPath);
                        }
                        if (shouldLogFinest) {
                            if (classWeaver.weavedPersistenceEntity) {
                                WeaverLogger.log(1, "weaved_persistenceentity", className);
                            }
                            if (classWeaver.weavedChangeTracker) {
                                WeaverLogger.log(1, "weaved_changetracker", className);
                            }
                            if (classWeaver.weavedLazy) {
                                WeaverLogger.log(1, "weaved_lazy", className);
                            }
                            if (classWeaver.weavedFetchGroups) {
                                WeaverLogger.log(1, "weaved_fetchgroups", className);
                            }
                            if (classWeaver.weavedRest) {
                                WeaverLogger.log(1, "weaved_rest", className);
                            }
                            WeaverLogger.log(1, "end_weaving_class", className);
                        }
                        return bytes;
                    }
                    if (shouldLogFinest) {
                        WeaverLogger.log(1, "end_weaving_class", className);
                    }
                    break block30;
                }
                if (shouldLogFinest) {
                    WeaverLogger.log(1, "transform_missing_class_details", className);
                }
            }
            catch (Throwable exception) {
                if (!WeaverLogger.shouldLog(3)) break block30;
                WeaverLogger.log(3, EXCEPTION_WHILE_WEAVING, exception, className);
                if (!shouldLogFinest) break block30;
                WeaverLogger.logThrowable(1, exception);
            }
        }
        if (shouldLogFinest) {
            WeaverLogger.log(1, "transform_existing_class_bytes", className);
        }
        return null;
    }

    protected static String getShortName(String name) {
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            if ((name = name.substring(pos + 1)).endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            return name;
        }
        return "";
    }
}

