/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.ClassExtractor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

public class MethodClassExtractor
extends ClassExtractor {
    protected transient ClassDescriptor descriptor;
    protected String classExtractionMethodName;
    protected transient Method classExtractionMethod;

    public Method getClassExtractionMethod() {
        return this.classExtractionMethod;
    }

    public String getClassExtractionMethodName() {
        return this.classExtractionMethodName;
    }

    protected void setClassExtractionMethod(Method classExtractionMethod) {
        this.classExtractionMethod = classExtractionMethod;
    }

    public void setClassExtractionMethodName(String staticClassClassExtractionMethod) {
        this.classExtractionMethodName = staticClassClassExtractionMethod;
    }

    @Override
    public void initialize(ClassDescriptor descriptor, Session session) throws DescriptorException {
        this.setDescriptor(descriptor);
        Class[] declarationParameters = new Class[]{ClassConstants.DatabaseRow_Class};
        try {
            this.setClassExtractionMethod(Helper.getDeclaredMethod(descriptor.getJavaClass(), this.getClassExtractionMethodName(), declarationParameters));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            declarationParameters[0] = ClassConstants.Record_Class;
            try {
                this.setClassExtractionMethod(Helper.getDeclaredMethod(descriptor.getJavaClass(), this.getClassExtractionMethodName(), declarationParameters));
            }
            catch (NoSuchMethodException exception) {
                throw DescriptorException.noSuchMethodWhileInitializingClassExtractionMethod(this.getClassExtractionMethodName(), descriptor, exception);
            }
            catch (SecurityException exception) {
                throw DescriptorException.securityWhileInitializingClassExtractionMethod(this.getClassExtractionMethodName(), descriptor, exception);
            }
        }
        catch (SecurityException exception) {
            throw DescriptorException.securityWhileInitializingClassExtractionMethod(this.getClassExtractionMethodName(), descriptor, exception);
        }
        if (!Modifier.isStatic(this.getClassExtractionMethod().getModifiers())) {
            throw DescriptorException.classExtractionMethodMustBeStatic(this.getClassExtractionMethodName(), descriptor);
        }
    }

    @Override
    public Class extractClassFromRow(Record row, Session session) {
        Class classForRow;
        block7: {
            try {
                Object[] arguments = new Object[]{row};
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        classForRow = (Class)AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getClassExtractionMethod(), null, arguments));
                        break block7;
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw DescriptorException.illegalAccessWhileInvokingRowExtractionMethod((AbstractRecord)row, this.getClassExtractionMethod(), this.getDescriptor(), throwableException);
                        }
                        throw DescriptorException.targetInvocationWhileInvokingRowExtractionMethod((AbstractRecord)row, this.getClassExtractionMethod(), this.getDescriptor(), throwableException);
                    }
                }
                classForRow = (Class)PrivilegedAccessHelper.invokeMethod(this.getClassExtractionMethod(), null, arguments);
            }
            catch (IllegalAccessException exception) {
                throw DescriptorException.illegalAccessWhileInvokingRowExtractionMethod((AbstractRecord)row, this.getClassExtractionMethod(), this.getDescriptor(), exception);
            }
            catch (InvocationTargetException exception) {
                throw DescriptorException.targetInvocationWhileInvokingRowExtractionMethod((AbstractRecord)row, this.getClassExtractionMethod(), this.getDescriptor(), exception);
            }
        }
        return classForRow;
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }
}

