/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus.locators;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.sisu.locators.BeanLocator;
import org.eclipse.sisu.plexus.config.PlexusBean;
import org.eclipse.sisu.plexus.config.PlexusBeanLocator;
import org.eclipse.sisu.plexus.locators.DefaultPlexusBeans;
import org.eclipse.sisu.plexus.locators.HintedPlexusBeans;
import org.eclipse.sisu.plexus.locators.RealmFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class DefaultPlexusBeanLocator
implements PlexusBeanLocator {
    private static final String REALM_VISIBILITY = "realm";
    private final BeanLocator beanLocator;
    private final String visibility;

    @Inject
    public DefaultPlexusBeanLocator(BeanLocator beanLocator) {
        this(beanLocator, REALM_VISIBILITY);
    }

    public DefaultPlexusBeanLocator(BeanLocator beanLocator, String visibility) {
        this.beanLocator = beanLocator;
        this.visibility = visibility;
    }

    @Override
    public <T> Iterable<PlexusBean<T>> locate(TypeLiteral<T> role, String ... hints) {
        Key key = hints.length == 1 ? Key.get(role, (Annotation)Names.named((String)hints[0])) : Key.get(role, Named.class);
        RealmFilter beans = this.beanLocator.locate(key);
        if (REALM_VISIBILITY.equalsIgnoreCase(this.visibility)) {
            beans = new RealmFilter(beans);
        }
        return hints.length <= 1 ? new DefaultPlexusBeans(beans) : new HintedPlexusBeans<T>(beans, role, hints);
    }
}

