/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.mojos;

import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public class CachingWriter
extends StringWriter {
    private final Path path;
    private final Charset charset;

    public CachingWriter(Path path, Charset charset) {
        this.path = Objects.requireNonNull(path);
        this.charset = Objects.requireNonNull(charset);
    }

    @Override
    public void close() throws IOException {
        String old;
        String str = this.getBuffer().toString();
        if (Files.exists(this.path, new LinkOption[0]) && str.equals(old = CachingWriter.readString(this.path, this.charset))) {
            return;
        }
        CachingWriter.writeString(this.path, str, this.charset);
    }

    private static String readString(Path path, Charset charset) throws IOException {
        byte[] ba = Files.readAllBytes(path);
        return new String(ba, charset);
    }

    private static void writeString(Path path, String str, Charset charset) throws IOException {
        byte[] ba = str.getBytes(charset);
        Files.write(path, ba, new OpenOption[0]);
    }
}

