/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.maven;

import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.lib.io.IO;
import java.io.File;
import java.util.Set;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.transformer.maven.AbstractTransformerMojo;
import org.eclipse.transformer.maven.action.TransformerJarChanges;

@Mojo(name="transform", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class TransformerDirectoryMojo
extends AbstractTransformerMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File transformDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip()) {
            return;
        }
        File transformDirectory = this.getTransformDirectory();
        this.getLogger().debug("Transforming directory {}", (Object)transformDirectory);
        try (Jar jar = new Jar(transformDirectory);){
            String inputName;
            MojoExecution mojoExecution = this.getMojoExecution();
            String outputName = inputName = "transformer:" + mojoExecution.getGoal() + "@" + mojoExecution.getExecutionId();
            TransformerJarChanges lastActiveChanges = this.transform(jar, inputName, outputName);
            this.writeOutput(jar, transformDirectory, lastActiveChanges.getChanged(), lastActiveChanges.getRemoved());
        }
        catch (Exception e) {
            throw new MojoFailureException("Exception transforming directory", (Throwable)e);
        }
    }

    private void writeOutput(Jar jar, File transformDirectory, Set<String> changed, Set<String> removed) throws Exception {
        File file;
        this.getLogger().debug("Updating directory {}", (Object)transformDirectory);
        this.getLogger().debug("Changed in outputDirectory {}", changed);
        for (String change : changed) {
            file = IO.getBasedFile((File)transformDirectory, (String)change);
            IO.mkdirs((File)file.getParentFile());
            Resource resource = jar.getResource(change);
            resource.write(file);
        }
        this.getLogger().debug("Removed from outputDirectory {}", removed);
        for (String remove : removed) {
            if (changed.contains(remove)) continue;
            file = IO.getBasedFile((File)transformDirectory, (String)remove);
            IO.delete((File)file);
        }
        this.getBuildContext().refresh(transformDirectory);
    }

    public File getTransformDirectory() {
        return this.transformDirectory;
    }
}

