/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.execution.ExtensionValuesStore;
import org.junit.jupiter.engine.execution.NamespaceAwareStore;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.reporting.ReportEntry;

abstract class AbstractExtensionContext<T extends TestDescriptor>
implements ExtensionContext {
    private final ExtensionContext parent;
    private final EngineExecutionListener engineExecutionListener;
    private final T testDescriptor;
    private final ExtensionValuesStore valuesStore;

    AbstractExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, T testDescriptor) {
        this.parent = parent;
        this.engineExecutionListener = engineExecutionListener;
        this.testDescriptor = testDescriptor;
        this.valuesStore = this.createStore(parent);
    }

    private ExtensionValuesStore createStore(ExtensionContext parent) {
        ExtensionValuesStore parentStore = null;
        if (parent != null) {
            parentStore = ((AbstractExtensionContext)parent).valuesStore;
        }
        return new ExtensionValuesStore(parentStore);
    }

    public String getUniqueId() {
        return this.getTestDescriptor().getUniqueId().toString();
    }

    public String getDisplayName() {
        return this.getTestDescriptor().getDisplayName();
    }

    public void publishReportEntry(Map<String, String> values) {
        this.engineExecutionListener.reportingEntryPublished((TestDescriptor)this.testDescriptor, ReportEntry.from(values));
    }

    public Optional<ExtensionContext> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public ExtensionContext getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    protected T getTestDescriptor() {
        return this.testDescriptor;
    }

    public ExtensionContext.Store getStore(ExtensionContext.Namespace namespace) {
        Preconditions.notNull(namespace, "Namespace must not be null");
        return new NamespaceAwareStore(this.valuesStore, namespace);
    }

    public Set<String> getTags() {
        return this.testDescriptor.getTags().stream().map(TestTag::getName).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

