/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.descriptor.AbstractExtensionContext;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.execution.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;

@API(status=API.Status.INTERNAL, since="5.0")
public final class ClassExtensionContext
extends AbstractExtensionContext<ClassTestDescriptor> {
    private final ThrowableCollector throwableCollector;
    private Object testInstance;

    public ClassExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, ClassTestDescriptor testDescriptor, ThrowableCollector throwableCollector) {
        super(parent, engineExecutionListener, testDescriptor);
        this.throwableCollector = throwableCollector;
    }

    public Optional<AnnotatedElement> getElement() {
        return Optional.of(((ClassTestDescriptor)this.getTestDescriptor()).getTestClass());
    }

    public Optional<Class<?>> getTestClass() {
        return Optional.of(((ClassTestDescriptor)this.getTestDescriptor()).getTestClass());
    }

    void setTestInstance(Object testInstance) {
        this.testInstance = testInstance;
    }

    public Optional<Object> getTestInstance() {
        return Optional.ofNullable(this.testInstance);
    }

    public Optional<Method> getTestMethod() {
        return Optional.empty();
    }

    public Optional<Throwable> getExecutionException() {
        return Optional.ofNullable(this.throwableCollector.getThrowable());
    }
}

