/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestTag;
import org.junit.platform.launcher.PostDiscoveryFilter;

@API(status=API.Status.STABLE, since="1.0")
public final class TagFilter {
    private TagFilter() {
    }

    public static PostDiscoveryFilter includeTags(String ... tags) throws PreconditionViolationException {
        Preconditions.notNull(tags, "tags array must not be null");
        return TagFilter.includeTags(Arrays.asList(tags));
    }

    public static PostDiscoveryFilter includeTags(List<String> tags) throws PreconditionViolationException {
        Preconditions.notEmpty(tags, "tags list must not be null or empty");
        List<TestTag> activeTags = TagFilter.toTestTags(tags);
        return descriptor -> FilterResult.includedIf(descriptor.getTags().stream().anyMatch(activeTags::contains));
    }

    public static PostDiscoveryFilter excludeTags(String ... tags) throws PreconditionViolationException {
        Preconditions.notNull(tags, "tags array must not be null");
        return TagFilter.excludeTags(Arrays.asList(tags));
    }

    public static PostDiscoveryFilter excludeTags(List<String> tags) throws PreconditionViolationException {
        Preconditions.notEmpty(tags, "tags list must not be null or empty");
        List<TestTag> activeTags = TagFilter.toTestTags(tags);
        return descriptor -> FilterResult.includedIf(descriptor.getTags().stream().noneMatch(activeTags::contains));
    }

    private static List<TestTag> toTestTags(List<String> tags) {
        return tags.stream().map(TestTag::create).collect(Collectors.toList());
    }
}

