/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.support;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.runner.Description;

@API(status=API.Status.INTERNAL, since="4.12")
public class UniqueIdReader
implements Function<Description, Serializable> {
    private final Logger logger;
    private final String fieldName;

    public UniqueIdReader(Logger logger) {
        this(logger, "fUniqueId");
    }

    UniqueIdReader(Logger logger, String fieldName) {
        this.logger = logger;
        this.fieldName = fieldName;
    }

    @Override
    public Serializable apply(Description description) {
        Optional<Object> result = ReflectionUtils.readFieldValue(Description.class, this.fieldName, description);
        return result.map(Serializable.class::cast).orElseGet(() -> {
            this.logger.warn(() -> String.format("Could not read unique ID for Description; using display name instead: %s", description.toString()));
            return description.getDisplayName();
        });
    }
}

