/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExecutableInvoker;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.execution.ParameterResolutionUtils;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="5.9")
public class DefaultExecutableInvoker
implements ExecutableInvoker {
    private final ExtensionContext extensionContext;
    private final ExtensionRegistry extensionRegistry;

    public DefaultExecutableInvoker(ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        this.extensionContext = extensionContext;
        this.extensionRegistry = extensionRegistry;
    }

    public DefaultExecutableInvoker(JupiterEngineExecutionContext context) {
        this(context.getExtensionContext(), context.getExtensionRegistry());
    }

    public <T> T invoke(Constructor<T> constructor, Object outerInstance) {
        Object[] arguments = ParameterResolutionUtils.resolveParameters(constructor, Optional.empty(), Optional.ofNullable(outerInstance), this.extensionContext, this.extensionRegistry);
        return ReflectionUtils.newInstance(constructor, arguments);
    }

    public Object invoke(Method method, Object target) {
        Object[] arguments = ParameterResolutionUtils.resolveParameters(method, Optional.ofNullable(target), this.extensionContext, this.extensionRegistry);
        return ReflectionUtils.invokeMethod(method, target, arguments);
    }
}

