/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.osgibooter;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class CombinedClassLoader
extends ClassLoader {
    private ClassLoader[] loaders;

    public CombinedClassLoader(ClassLoader ... loaders) {
        this.loaders = loaders;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader loader : this.loaders) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (ClassLoader loader : this.loaders) {
            Enumeration<URL> resources = loader.getResources(name);
            while (resources.hasMoreElements()) {
                result.add(resources.nextElement());
            }
        }
        return Collections.enumeration(result);
    }

    @Override
    protected URL findResource(String name) {
        URL url = null;
        for (ClassLoader loader : this.loaders) {
            url = loader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }
}

