/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.internal.p2.metadata.repository.Messages;
import org.eclipse.equinox.internal.p2.metadata.repository.io.MetadataParser;
import org.eclipse.equinox.internal.p2.metadata.repository.io.MetadataWriter;
import org.eclipse.equinox.internal.p2.persistence.XMLParser;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.tycho.p2maven.P2Plugin;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Component(role=MetadataIO.class)
public class MetadataIO {
    public MetadataFactory.InstallableUnitDescription readOneIU(InputStream is) throws IOException {
        Parser parser = new Parser(Parser.PARSER_MODE.IU);
        parser.parse(is, (IProgressMonitor)new NullProgressMonitor());
        return parser.getUnits().get(0);
    }

    public Set<IInstallableUnit> readXML(InputStream is) throws IOException {
        Parser parser = new Parser(Parser.PARSER_MODE.REPO);
        parser.parse(is, (IProgressMonitor)new NullProgressMonitor());
        LinkedHashSet<IInstallableUnit> units = new LinkedHashSet<IInstallableUnit>();
        for (MetadataFactory.InstallableUnitDescription desc : parser.getUnits()) {
            units.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc));
        }
        return units;
    }

    public void writeXML(Collection<? extends IInstallableUnit> units, OutputStream os) throws IOException {
        new Writer(os).write(units);
    }

    public void writeXML(Collection<? extends IInstallableUnit> units, File file) throws IOException {
        file.getParentFile().mkdirs();
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            this.writeXML(units, os);
        }
    }

    public Set<IInstallableUnit> readXML(File artifact) throws IOException {
        try (FileInputStream stream = new FileInputStream(artifact);){
            Set<IInstallableUnit> set = this.readXML(stream);
            return set;
        }
    }

    private static class Parser
    extends MetadataParser {
        private PARSER_MODE mode;
        private List<MetadataFactory.InstallableUnitDescription> units;

        public Parser(PARSER_MODE mode) {
            super(SAXParserFactory.newInstance(), P2Plugin.BUNDLE_ID);
            this.mode = mode;
        }

        protected String getErrorMessage() {
            return null;
        }

        protected Object getRootObject() {
            return null;
        }

        public synchronized void parse(InputStream stream, IProgressMonitor monitor) throws IOException {
            this.status = null;
            this.setProgressMonitor(monitor);
            monitor.beginTask(Messages.repo_loading, -1);
            try {
                this.getParser();
                InstallableUnitsHandler handler = new InstallableUnitsHandler();
                if (this.mode.equals((Object)PARSER_MODE.REPO)) {
                    this.xmlReader.setContentHandler((ContentHandler)((Object)new RepositoryDocHandler("units", handler)));
                } else {
                    this.xmlReader.setContentHandler((ContentHandler)((Object)handler));
                }
                this.xmlReader.parse(new InputSource(stream));
                if (this.isValidXML()) {
                    this.units = handler.getUnits();
                }
            }
            catch (SAXException e) {
                if (!(e.getException() instanceof OperationCanceledException)) {
                    throw new IOException(e.getMessage());
                }
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e.getMessage());
            }
            finally {
                monitor.done();
                stream.close();
            }
        }

        public List<MetadataFactory.InstallableUnitDescription> getUnits() {
            return this.units;
        }

        public static enum PARSER_MODE {
            REPO,
            IU;

        }

        private final class InstallableUnitsHandler
        extends XMLParser.RootHandler {
            private List<MetadataFactory.InstallableUnitDescription> units;

            private InstallableUnitsHandler() {
                super((XMLParser)Parser.this);
                this.units = new ArrayList<MetadataFactory.InstallableUnitDescription>();
            }

            protected void handleRootAttributes(Attributes attributes) {
            }

            public List<MetadataFactory.InstallableUnitDescription> getUnits() {
                return this.units;
            }

            public void startElement(String name, Attributes attributes) throws SAXException {
                if (name.equals("unit")) {
                    new MetadataParser.InstallableUnitHandler((MetadataParser)Parser.this, (XMLParser.AbstractHandler)this, attributes, this.units);
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }

        private final class RepositoryDocHandler
        extends XMLParser.DocHandler {
            public RepositoryDocHandler(String rootName, XMLParser.RootHandler rootHandler) {
                super((XMLParser)Parser.this, rootName, rootHandler);
            }

            public void processingInstruction(String target, String data) throws SAXException {
            }
        }
    }

    private static class Writer
    extends MetadataWriter {
        public Writer(OutputStream output) {
            super(output, null);
        }

        public void write(Collection<? extends IInstallableUnit> units) {
            this.start("units");
            this.attribute("size", units.size());
            for (IInstallableUnit iInstallableUnit : units) {
                this.writeInstallableUnit(iInstallableUnit);
            }
            this.end("units");
            this.flush();
        }
    }
}

