/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.tycho.PlatformPropertiesUtils;
import org.osgi.framework.Filter;

public final class TargetEnvironment {
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static final String OSGI_OS = "osgi.os";
    private static final String OSGI_WS = "osgi.ws";
    private static final String OSGI_ARCH = "osgi.arch";
    private static TargetEnvironment runningEnvironment;
    private String os;
    private String ws;
    private String arch;

    public TargetEnvironment() {
    }

    public TargetEnvironment(String os, String ws, String arch) {
        this.os = os;
        this.ws = ws;
        this.arch = arch;
    }

    public String getOs() {
        return this.os;
    }

    public String getWs() {
        return this.ws;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean match(String os, String ws, String arch) {
        return !(os != null && !os.equals(this.os) || ws != null && !ws.equals(this.ws) || arch != null && !arch.equals(this.arch));
    }

    public boolean match(Filter filter) {
        if (filter != null) {
            return filter.matches(this.toFilterProperties());
        }
        return true;
    }

    public String toConfigSpec() {
        return this.ws + "." + this.os + "." + this.arch;
    }

    public boolean isWindows() {
        return "win32".equals(this.getOs());
    }

    public Map<String, String> toFilterProperties() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(3);
        if (this.os != null) {
            result.put(OSGI_OS, this.os);
        }
        if (this.ws != null) {
            result.put(OSGI_WS, this.ws);
        }
        if (this.arch != null) {
            result.put(OSGI_ARCH, this.arch);
        }
        return result;
    }

    public boolean match(IMatchExpression<IInstallableUnit> filter) {
        if (filter == null) {
            return true;
        }
        return filter.isMatch((Object)InstallableUnit.contextIU(this.toFilterProperties()));
    }

    public String toFilterExpression() {
        ArrayList<CallSite> conditions = new ArrayList<CallSite>();
        if (this.os != null) {
            conditions.add((CallSite)((Object)("osgi.os=" + this.os)));
        }
        if (this.ws != null) {
            conditions.add((CallSite)((Object)("osgi.ws=" + this.ws)));
        }
        if (this.arch != null) {
            conditions.add((CallSite)((Object)("osgi.arch=" + this.arch)));
        }
        if (conditions.isEmpty()) {
            return null;
        }
        if (conditions.size() == 1) {
            return "(" + (String)conditions.get(0) + ")";
        }
        StringBuilder result = new StringBuilder("(&");
        for (String string : conditions) {
            result.append(" (").append(string).append(")");
        }
        result.append(" )");
        return result.toString();
    }

    public String toString() {
        return this.os + "/" + this.ws + "/" + this.arch;
    }

    public int hashCode() {
        return Objects.hash(this.os, this.ws, this.arch);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof TargetEnvironment)) return false;
        TargetEnvironment other = (TargetEnvironment)obj;
        if (!Objects.equals(this.os, other.os)) return false;
        if (!Objects.equals(this.ws, other.ws)) return false;
        if (!Objects.equals(this.arch, other.arch)) return false;
        return true;
    }

    public static TargetEnvironment getRunningEnvironment() {
        if (runningEnvironment == null) {
            String os = PlatformPropertiesUtils.getOS(EMPTY_PROPERTIES);
            String ws = PlatformPropertiesUtils.getWS(EMPTY_PROPERTIES);
            String arch = PlatformPropertiesUtils.getArch(EMPTY_PROPERTIES);
            runningEnvironment = new TargetEnvironment(os, ws, arch);
        }
        return runningEnvironment;
    }
}

