/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee;

import java.util.List;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.core.ee.CustomExecutionEnvironment;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentUtils;
import org.eclipse.tycho.core.ee.UnknownEnvironmentException;
import org.eclipse.tycho.core.ee.shared.BuildFailureException;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironment;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.core.ee.shared.SystemCapability;

public class ExecutionEnvironmentConfigurationImpl
implements ExecutionEnvironmentConfiguration {
    private static final String DEFAULT_EXECUTION_ENVIRONMENT = "JavaSE-1.6";
    private static final int PRIMARY = 0;
    private static final int SECONDARY = 1;
    private Logger logger;
    private final ProfileConfiguration[] configurations = new ProfileConfiguration[2];
    private String effectiveProfileName = null;
    private CustomExecutionEnvironment customExecutionEnvironment;
    private final boolean ignoredByResolver;

    public ExecutionEnvironmentConfigurationImpl(Logger logger, boolean ignoredByResolver) {
        this.logger = logger;
        this.ignoredByResolver = ignoredByResolver;
    }

    public void overrideProfileConfiguration(String profileName, String configurationOrigin) throws IllegalStateException {
        this.checkConfigurationMutable();
        if (profileName == null) {
            throw new NullPointerException();
        }
        this.configurations[0] = new ProfileConfiguration(profileName, configurationOrigin);
    }

    public void setProfileConfiguration(String profileName, String configurationOrigin) throws IllegalStateException {
        this.checkConfigurationMutable();
        if (profileName == null) {
            throw new NullPointerException();
        }
        this.configurations[1] = new ProfileConfiguration(profileName, configurationOrigin);
    }

    private void checkConfigurationMutable() throws IllegalStateException {
        if (this.effectiveProfileName != null) {
            throw new IllegalStateException("Cannot change execution environment configuration after it has been used");
        }
    }

    public String getProfileName() {
        if (this.effectiveProfileName == null) {
            this.effectiveProfileName = this.computeEffectiveProfileName();
        }
        return this.effectiveProfileName;
    }

    private String computeEffectiveProfileName() {
        for (ProfileConfiguration entry : this.configurations) {
            if (entry == null) continue;
            this.logger.debug("Using execution environment '" + entry.profileName + "' configured in " + entry.origin);
            return entry.profileName;
        }
        this.logger.debug("Using default execution environment 'JavaSE-1.6'");
        return DEFAULT_EXECUTION_ENVIRONMENT;
    }

    public boolean isCustomProfile() {
        String profileName = this.getProfileName();
        try {
            ExecutionEnvironmentUtils.getExecutionEnvironment(profileName);
            return false;
        }
        catch (UnknownEnvironmentException e) {
            if (this.ignoredByResolver) {
                throw new BuildFailureException("When using a custom execution environment profile, resolveWithExecutionEnvironmentConstraints must not be set to false");
            }
            return true;
        }
    }

    public void setFullSpecificationForCustomProfile(List<SystemCapability> systemCapabilities) throws IllegalStateException {
        if (!this.isCustomProfile()) {
            throw new IllegalStateException("Cannot set full specification when a standard execution environment is configured");
        }
        if (this.customExecutionEnvironment != null) {
            throw new IllegalStateException("Cannot set full specification for a custom profile more than once");
        }
        this.customExecutionEnvironment = new CustomExecutionEnvironment(this.getProfileName(), systemCapabilities);
    }

    public ExecutionEnvironment getFullSpecification() throws IllegalStateException {
        if (this.isCustomProfile()) {
            if (this.customExecutionEnvironment == null) {
                throw new IllegalStateException("Full specification of custom profile is not (yet) determined");
            }
            return this.customExecutionEnvironment;
        }
        return ExecutionEnvironmentUtils.getExecutionEnvironment(this.getProfileName());
    }

    public boolean isIgnoredByResolver() {
        return this.ignoredByResolver;
    }

    private static class ProfileConfiguration {
        final String profileName;
        final String origin;

        ProfileConfiguration(String profileName, String origin) {
            this.profileName = profileName;
            this.origin = origin;
        }
    }
}

