/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.core.osgitools.OsgiManifestParserException;
import org.eclipse.tycho.core.shared.LRUCache;
import org.eclipse.tycho.locking.facade.FileLockService;
import org.eclipse.tycho.locking.facade.FileLocker;

@Component(role=BundleReader.class)
public class DefaultBundleReader
extends AbstractLogEnabled
implements BundleReader {
    public static final String CACHE_PATH = ".cache/tycho";
    private final LRUCache<String, OsgiManifest> manifestCache = new LRUCache(50);
    private File cacheDir;
    private Set<String> extractedFiles = new HashSet<String>();
    @Requirement
    private FileLockService fileLockService;

    @Override
    public OsgiManifest loadManifest(File bundleLocation) {
        String locationPath = bundleLocation.getAbsolutePath();
        OsgiManifest manifest = (OsgiManifest)this.manifestCache.get((Object)locationPath);
        if (manifest == null) {
            manifest = this.doLoadManifest(bundleLocation);
            this.manifestCache.put((Object)locationPath, (Object)manifest);
        }
        return manifest;
    }

    private OsgiManifest doLoadManifest(File bundleLocation) {
        try {
            if (bundleLocation.isDirectory()) {
                return this.loadManifestFromDirectory(bundleLocation);
            }
            if (bundleLocation.isFile()) {
                return this.loadManifestFromFile(bundleLocation);
            }
            throw new OsgiManifestParserException(new File(bundleLocation, "META-INF/MANIFEST.MF").getAbsolutePath(), "Manifest file not found");
        }
        catch (IOException e) {
            throw new OsgiManifestParserException(bundleLocation.getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OsgiManifest loadManifestFromFile(File bundleLocation) throws IOException {
        if (!bundleLocation.getName().toLowerCase().endsWith(".jar")) {
            return this.loadManifestFile(bundleLocation);
        }
        ZipFile jar = new ZipFile(bundleLocation, 1);
        try {
            ZipEntry manifestEntry = jar.getEntry("META-INF/MANIFEST.MF");
            if (manifestEntry != null) {
                InputStream stream = jar.getInputStream(manifestEntry);
                OsgiManifest osgiManifest = OsgiManifest.parse(stream, bundleLocation.getAbsolutePath() + "!/" + "META-INF/MANIFEST.MF");
                return osgiManifest;
            }
        }
        finally {
            jar.close();
        }
        throw new OsgiManifestParserException(bundleLocation.getAbsolutePath(), "Manifest file not found in JAR archive");
    }

    private OsgiManifest loadManifestFromDirectory(File directory) throws IOException {
        File manifestFile = new File(directory, "META-INF/MANIFEST.MF");
        if (!manifestFile.isFile()) {
            throw new OsgiManifestParserException(manifestFile.getAbsolutePath(), "Manifest file not found");
        }
        return this.loadManifestFile(manifestFile);
    }

    private OsgiManifest loadManifestFile(File manifestFile) throws IOException, OsgiManifestParserException {
        return OsgiManifest.parse(new FileInputStream(manifestFile), manifestFile.getAbsolutePath());
    }

    public void setLocationRepository(File basedir) {
        this.cacheDir = new File(basedir, CACHE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getEntry(File bundleLocation, String path) {
        File result;
        if (path.startsWith("external:")) {
            this.getLogger().warn("Ignoring Bundle-ClassPath entry '" + path + "' of bundle " + bundleLocation);
            return null;
        }
        if (bundleLocation.isDirectory()) {
            result = new File(bundleLocation, path);
        } else {
            try {
                File outputDirectory = new File(this.cacheDir, bundleLocation.getName());
                result = new File(outputDirectory, path);
                String resultPath = result.getCanonicalPath();
                if (this.extractedFiles.contains(resultPath) && result.exists()) {
                    return result;
                }
                FileLocker locker = this.fileLockService.getFileLocker(outputDirectory);
                locker.lock(300000L);
                try {
                    this.extractZipEntries(bundleLocation, path, outputDirectory);
                }
                finally {
                    locker.release();
                }
                this.extractedFiles.add(resultPath);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException while extracting '" + path + "' from " + bundleLocation, e);
            }
        }
        if (result.exists()) {
            return result;
        }
        this.getLogger().debug("Bundle-ClassPath entry " + path + " does not exist in" + bundleLocation);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractZipEntries(File bundleLocation, String path, File outputDirectory) throws IOException {
        ZipFile zip = new ZipFile(bundleLocation);
        try {
            InputStream singleEntryStream;
            ZipEntry singleEntry = zip.getEntry(path);
            if (singleEntry != null && !singleEntry.isDirectory() && (singleEntryStream = zip.getInputStream(singleEntry)) != null) {
                DefaultBundleReader.copyStreamToFile(singleEntryStream, new File(outputDirectory, singleEntry.getName()), singleEntry.getTime());
            } else {
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    if (zipEntry.isDirectory() || !zipEntry.getName().startsWith(path)) continue;
                    DefaultBundleReader.copyStreamToFile(zip.getInputStream(zipEntry), new File(outputDirectory, zipEntry.getName()), zipEntry.getTime());
                }
            }
        }
        finally {
            zip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStreamToFile(InputStream in, File outputFile, long timestamp) throws IOException {
        if (in == null) {
            return;
        }
        outputFile.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(outputFile);
        try {
            IOUtil.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            in.close();
            out.close();
        }
        if (timestamp > 0L) {
            outputFile.setLastModified(timestamp);
        }
    }
}

