/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironment;
import org.eclipse.tycho.core.ee.shared.SystemCapability;

public class CustomExecutionEnvironment
implements ExecutionEnvironment {
    private static final Pattern VERSION_NUMBER_DOT_NUMBER_DOT_ZERO_PATTERN = Pattern.compile("(\\d+\\.\\d+)\\.0");
    private static final Pattern JAVA_SECOND_EDITION_VERSIONS_PATTERN = Pattern.compile("(1\\.[0-5])");
    private final String profileName;
    private List<ExecutionEnvironment.SystemPackageEntry> systemPackages = new LinkedList<ExecutionEnvironment.SystemPackageEntry>();
    private final Properties properties = new Properties();

    public CustomExecutionEnvironment(String profileName, List<SystemCapability> systemCapabilities) {
        this.profileName = profileName;
        this.setSystemPackages(systemCapabilities);
        this.setExecutionEnvironmentProperties(systemCapabilities);
        this.setOsgiSystemCapabilities(systemCapabilities);
        this.properties.setProperty("osgi.java.profile.name", profileName);
    }

    private void setSystemPackages(List<SystemCapability> systemCapabilities) {
        this.systemPackages = systemCapabilities.stream().filter(capability -> capability.getType() == SystemCapability.Type.JAVA_PACKAGE).map(capability -> new ExecutionEnvironment.SystemPackageEntry(capability.getName(), capability.getVersion())).collect(Collectors.toList());
        this.setPropertyIfNotEmpty("org.osgi.framework.system.packages", new StringBuilder(this.systemPackages.stream().map(ExecutionEnvironment.SystemPackageEntry::toPackageSpecifier).collect(Collectors.joining(","))));
    }

    private void setExecutionEnvironmentProperties(List<SystemCapability> systemCapabilities) {
        StringBuilder executionEnvironmentProperty = new StringBuilder();
        for (SystemCapability capability : systemCapabilities) {
            if (capability.getType() != SystemCapability.Type.OSGI_EE) continue;
            String environmentName = capability.getName();
            String version = this.normalizeVersion(capability.getVersion());
            CustomExecutionEnvironment.append(executionEnvironmentProperty, this.toExecutionEnvironment(environmentName, version));
        }
        this.setPropertyIfNotEmpty("org.osgi.framework.executionenvironment", executionEnvironmentProperty);
    }

    private void setOsgiSystemCapabilities(List<SystemCapability> systemCapabilities) {
        LinkedHashMap<String, MultipleVersionsCapability> capabilityMap = new LinkedHashMap<String, MultipleVersionsCapability>();
        for (SystemCapability capability : systemCapabilities) {
            if (capability.getType() != SystemCapability.Type.OSGI_EE) continue;
            String environmentName = capability.getName();
            String version = this.normalizeVersion(capability.getVersion());
            if (capabilityMap.containsKey(environmentName)) {
                ((MultipleVersionsCapability)capabilityMap.get(environmentName)).addVersion(version);
                continue;
            }
            capabilityMap.put(environmentName, new MultipleVersionsCapability(environmentName, version));
        }
        StringBuilder systemCapabilitesProperty = new StringBuilder();
        for (MultipleVersionsCapability capability : capabilityMap.values()) {
            CustomExecutionEnvironment.append(systemCapabilitesProperty, capability.toString());
        }
        this.setPropertyIfNotEmpty("org.osgi.framework.system.capabilities", systemCapabilitesProperty);
    }

    private void setPropertyIfNotEmpty(String key, StringBuilder value) {
        if (value.length() > 0) {
            this.properties.setProperty(key, value.toString());
        }
    }

    private static void append(StringBuilder propertyValue, String value) {
        if (propertyValue.length() > 0) {
            propertyValue.append(",");
        }
        propertyValue.append(value);
    }

    private String normalizeVersion(String version) {
        Matcher matcher = VERSION_NUMBER_DOT_NUMBER_DOT_ZERO_PATTERN.matcher(version);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return version;
    }

    private String toExecutionEnvironment(String environmentName, String version) {
        if ("JavaSE".equals(environmentName) && JAVA_SECOND_EDITION_VERSIONS_PATTERN.matcher(version).matches()) {
            return this.appendVersion("J2SE", version);
        }
        if ("CDC/Foundation".equals(environmentName)) {
            return this.appendVersion("CDC", version) + "/" + this.appendVersion("Foundation", version);
        }
        return this.appendVersion(environmentName, version);
    }

    private String appendVersion(String value, String version) {
        return value + "-" + version;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public Properties getProfileProperties() {
        return this.properties;
    }

    public Collection<ExecutionEnvironment.SystemPackageEntry> getSystemPackages() {
        return Collections.unmodifiableList(this.systemPackages);
    }

    public String getCompilerSourceLevelDefault() {
        return null;
    }

    public String getCompilerTargetLevelDefault() {
        return null;
    }

    public boolean isCompatibleCompilerTargetLevel(String target) {
        return true;
    }

    public String toString() {
        return "custom OSGi profile '" + this.getProfileName() + "'";
    }

    private static final class MultipleVersionsCapability {
        final String name;
        int count = 0;
        final StringBuilder versions = new StringBuilder();

        public MultipleVersionsCapability(String environmentName, String version) {
            this.name = environmentName;
            this.addVersion(version);
        }

        private void addVersion(String version) {
            if (this.count > 0) {
                this.versions.append(", ");
            }
            this.versions.append(version);
            ++this.count;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("osgi.ee; osgi.ee=\"" + this.name + "\"; ");
            if (this.count <= 1) {
                result.append("version:Version=\"");
            } else {
                result.append("version:List<Version>=\"");
            }
            result.append((CharSequence)this.versions);
            result.append("\"");
            return result.toString();
        }
    }
}

