/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.classpath.ClasspathEntry;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.ArtifactDependencyWalker;
import org.eclipse.tycho.core.BundleProject;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentUtils;
import org.eclipse.tycho.core.ee.StandardExecutionEnvironment;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironment;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.core.osgitools.AbstractTychoProject;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultClasspathEntry;
import org.eclipse.tycho.core.osgitools.DefaultPluginDescription;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.DependencyComputer;
import org.eclipse.tycho.core.osgitools.EquinoxResolver;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.core.osgitools.project.BuildOutputJar;
import org.eclipse.tycho.core.osgitools.project.EclipsePluginProjectImpl;
import org.eclipse.tycho.core.shared.BuildPropertiesParser;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.model.UpdateSite;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;

@Component(role=TychoProject.class, hint="eclipse-plugin")
public class OsgiBundleProject
extends AbstractTychoProject
implements BundleProject {
    private static final String CTX_ARTIFACT_KEY = TychoConstants.CTX_BASENAME + "/osgiBundle/artifactKey";
    @Requirement
    private BundleReader bundleReader;
    @Requirement
    private BuildPropertiesParser buildPropertiesParser;
    @Requirement
    private EquinoxResolver resolver;
    @Requirement
    private DependencyComputer dependencyComputer;
    @Requirement
    private Logger logger;
    @Requirement
    private ToolchainManager toolchainManager;

    @Override
    public ArtifactDependencyWalker getDependencyWalker(ReactorProject project, TargetEnvironment environment) {
        return this.getDependencyWalker(project);
    }

    @Override
    public ArtifactDependencyWalker getDependencyWalker(ReactorProject project) {
        final DependencyArtifacts artifacts = this.getDependencyArtifacts(project);
        final List<ClasspathEntry> cp = this.getClasspath(project);
        return new ArtifactDependencyWalker(){

            @Override
            public void walk(ArtifactDependencyVisitor visitor) {
                for (ClasspathEntry entry : cp) {
                    ArtifactDescriptor artifact = artifacts.getArtifact(entry.getArtifactKey());
                    ArtifactKey key = artifact.getKey();
                    File location = artifact.getLocation(true);
                    ReactorProject project = artifact.getMavenProject();
                    String classifier = artifact.getClassifier();
                    Set installableUnits = artifact.getInstallableUnits();
                    DefaultPluginDescription plugin = new DefaultPluginDescription(key, location, project, classifier, null, installableUnits);
                    visitor.visitPlugin(plugin);
                }
            }

            @Override
            public void traverseFeature(File location, Feature feature, ArtifactDependencyVisitor visitor) {
            }

            @Override
            public void traverseUpdateSite(UpdateSite site, ArtifactDependencyVisitor artifactDependencyVisitor) {
            }

            @Override
            public void traverseProduct(ProductConfiguration productConfiguration, ArtifactDependencyVisitor visitor) {
            }
        };
    }

    @Override
    public ArtifactKey getArtifactKey(ReactorProject project) {
        ArtifactKey key = (ArtifactKey)project.getContextValue(CTX_ARTIFACT_KEY);
        if (key == null) {
            throw new IllegalStateException("Project has not been setup yet " + project.toString());
        }
        return key;
    }

    @Override
    public void setupProject(MavenSession session, MavenProject project) {
        ArtifactKey key = this.readArtifactKey(project.getBasedir());
        DefaultReactorProject.adapt(project).setContextValue(CTX_ARTIFACT_KEY, (Object)key);
    }

    public ArtifactKey readArtifactKey(File location) {
        OsgiManifest mf = this.bundleReader.loadManifest(location);
        return mf.toArtifactKey();
    }

    @Override
    public String getManifestValue(String key, MavenProject project) {
        return this.getManifest(DefaultReactorProject.adapt(project)).getValue(key);
    }

    private OsgiManifest getManifest(ReactorProject project) {
        return this.bundleReader.loadManifest(project.getBasedir());
    }

    @Override
    public void resolveClassPath(MavenSession session, MavenProject project) {
        DependencyArtifacts artifacts;
        ReactorProject reactorProject = DefaultReactorProject.adapt(project);
        ModuleContainer state = this.getResolverState(reactorProject, artifacts = this.getDependencyArtifacts(reactorProject), session);
        Module module = state.getModule(project.getBasedir().getAbsolutePath());
        if (module == null) {
            Module systemModule = state.getModule("System Bundle");
            if (project.getBasedir().equals(systemModule.getCurrentRevision().getRevisionInfo())) {
                module = systemModule;
            }
        }
        ModuleRevision bundleDescription = module.getCurrentRevision();
        ArrayList<ClasspathEntry> classpath = new ArrayList<ClasspathEntry>();
        ArrayList<ClasspathEntry.AccessRule> strictBootClasspathAccessRules = new ArrayList<ClasspathEntry.AccessRule>();
        strictBootClasspathAccessRules.add(new DefaultClasspathEntry.DefaultAccessRule("java/**", false));
        for (DependencyComputer.DependencyEntry entry : this.dependencyComputer.computeDependencies(bundleDescription)) {
            File location;
            if (0L == entry.module.getRevisions().getModule().getId() && entry.rules != null) {
                strictBootClasspathAccessRules.addAll(entry.rules);
            }
            if ((location = (File)entry.module.getRevisionInfo()) == null || !location.exists()) continue;
            ArtifactDescriptor otherArtifact = this.getArtifact(artifacts, location, entry.module.getSymbolicName());
            ReactorProject otherProject = otherArtifact.getMavenProject();
            List<File> locations = otherProject != null ? this.getOtherProjectClasspath(otherArtifact, otherProject, null) : this.getBundleClasspath(otherArtifact);
            if (locations.isEmpty() && !entry.rules.isEmpty()) {
                this.getLogger().warn("Empty classpath of required bundle " + otherArtifact);
            }
            classpath.add(new DefaultClasspathEntry(otherProject, otherArtifact.getKey(), locations, entry.rules));
        }
        this.addExtraClasspathEntries(classpath, reactorProject, artifacts);
        ArtifactDescriptor artifact = this.getArtifact(artifacts, project.getBasedir(), bundleDescription.getSymbolicName());
        List<File> projectClasspath = this.getThisProjectClasspath(artifact, reactorProject);
        classpath.add(new DefaultClasspathEntry(reactorProject, artifact.getKey(), projectClasspath, null));
        reactorProject.setContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_CLASSPATH, classpath);
        reactorProject.setContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_STRICT_BOOTCLASSPATH_ACCESSRULES, strictBootClasspathAccessRules);
        reactorProject.setContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_BOOTCLASSPATH_EXTRA_ACCESSRULES, this.dependencyComputer.computeBootClasspathExtraAccessRules(state));
        this.addPDESourceRoots(project);
    }

    protected ArtifactDescriptor getArtifact(DependencyArtifacts artifacts, File location, String id) {
        Map classified = artifacts.getArtifact(location);
        if (classified != null) {
            for (ArtifactDescriptor artifact : classified.values()) {
                if (!id.equals(artifact.getKey().getId())) continue;
                return artifact;
            }
        }
        return null;
    }

    private void addPDESourceRoots(MavenProject project) {
        EclipsePluginProjectImpl eclipsePluginProject = this.getEclipsePluginProject(DefaultReactorProject.adapt(project));
        for (BuildOutputJar outputJar : eclipsePluginProject.getOutputJars()) {
            for (File sourceFolder : outputJar.getSourceFolders()) {
                this.removeDuplicateTestCompileRoot(sourceFolder, project.getTestCompileSourceRoots());
                project.addCompileSourceRoot(sourceFolder.getAbsolutePath());
            }
        }
    }

    private void removeDuplicateTestCompileRoot(File sourceFolder, List<String> testCompileSourceRoots) {
        Iterator<String> iterator = testCompileSourceRoots.iterator();
        while (iterator.hasNext()) {
            String testCompileRoot = iterator.next();
            if (!sourceFolder.equals(new File(testCompileRoot))) continue;
            iterator.remove();
            this.getLogger().debug("Removed duplicate test compile root " + testCompileRoot + " from maven project model");
            return;
        }
    }

    private ModuleContainer getResolverState(ReactorProject project, DependencyArtifacts artifacts, MavenSession session) {
        try {
            ExecutionEnvironmentConfiguration eeConfiguration = TychoProjectUtils.getExecutionEnvironmentConfiguration(project);
            ExecutionEnvironment executionEnvironment = eeConfiguration.getFullSpecification();
            return this.resolver.newResolvedState(project, session, eeConfiguration.isIgnoredByResolver() ? null : executionEnvironment, artifacts);
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    public EclipsePluginProjectImpl getEclipsePluginProject(ReactorProject otherProject) {
        EclipsePluginProjectImpl pdeProject = (EclipsePluginProjectImpl)otherProject.getContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_PROJECT);
        if (pdeProject == null) {
            try {
                pdeProject = new EclipsePluginProjectImpl(otherProject, this.buildPropertiesParser);
                if (otherProject instanceof DefaultReactorProject) {
                    this.populateProperties(((DefaultReactorProject)otherProject).project.getProperties(), pdeProject);
                }
                otherProject.setContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_PROJECT, (Object)pdeProject);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return pdeProject;
    }

    private void populateProperties(Properties mavenProjectProperties, EclipsePluginProjectImpl pdeProject) {
        mavenProjectProperties.put("tychoProject.build.outputDirectories", pdeProject.getOutputJars().stream().map(BuildOutputJar::getOutputDirectory).map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
    }

    @Override
    public List<ClasspathEntry> getClasspath(ReactorProject project) {
        List classpath = (List)project.getContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_CLASSPATH);
        if (classpath == null) {
            throw new IllegalStateException();
        }
        return classpath;
    }

    @Override
    public List<ClasspathEntry.AccessRule> getBootClasspathExtraAccessRules(ReactorProject project) {
        List rules = (List)project.getContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_BOOTCLASSPATH_EXTRA_ACCESSRULES);
        if (rules == null) {
            throw new IllegalStateException();
        }
        return rules;
    }

    private List<File> getThisProjectClasspath(ArtifactDescriptor bundle, ReactorProject project) {
        LinkedHashSet<File> classpath = new LinkedHashSet<File>();
        EclipsePluginProjectImpl pdeProject = this.getEclipsePluginProject(project);
        Map<String, BuildOutputJar> outputJars = pdeProject.getOutputJarMap();
        for (BuildOutputJar jar : outputJars.values()) {
            classpath.add(jar.getOutputDirectory());
        }
        for (String cp : this.parseBundleClasspath(bundle)) {
            if (outputJars.containsKey(cp)) continue;
            classpath.add(new File(project.getBasedir(), cp));
        }
        return new ArrayList<File>(classpath);
    }

    private List<File> getOtherProjectClasspath(ArtifactDescriptor bundle, ReactorProject otherProject, String nestedPath) {
        LinkedHashSet<File> classpath = new LinkedHashSet<File>();
        EclipsePluginProjectImpl pdeProject = this.getEclipsePluginProject(otherProject);
        Map<String, BuildOutputJar> outputJars = pdeProject.getOutputJarMap();
        String[] bundleClassPath = nestedPath == null ? this.parseBundleClasspath(bundle) : new String[]{nestedPath};
        for (String cp : bundleClassPath) {
            if (outputJars.containsKey(cp)) {
                classpath.add(outputJars.get(cp).getOutputDirectory());
                continue;
            }
            classpath.add(new File(otherProject.getBasedir(), cp));
        }
        return new ArrayList<File>(classpath);
    }

    private void addExtraClasspathEntries(List<ClasspathEntry> classpath, ReactorProject project, DependencyArtifacts artifacts) {
        EclipsePluginProjectImpl pdeProject = this.getEclipsePluginProject(project);
        Collection<BuildOutputJar> outputJars = pdeProject.getOutputJarMap().values();
        for (BuildOutputJar buildOutputJar : outputJars) {
            List<String> entries = buildOutputJar.getExtraClasspathEntries();
            for (String entry : entries) {
                List<File> locations;
                Pattern platformURL = Pattern.compile("platform:/(plugin|fragment)/([^/]*)/*(.*)");
                Matcher m = platformURL.matcher(entry.trim());
                String bundleId = null;
                String path = null;
                if (m.matches()) {
                    ArtifactDescriptor matchingBundle;
                    bundleId = m.group(2).trim();
                    path = m.group(3).trim();
                    if (path != null && path.isEmpty()) {
                        path = null;
                    }
                    if ((matchingBundle = artifacts.getArtifact("eclipse-plugin", bundleId, null)) != null) {
                        locations = matchingBundle.getMavenProject() != null ? this.getOtherProjectClasspath(matchingBundle, matchingBundle.getMavenProject(), path) : (path != null ? this.getBundleEntry(matchingBundle, path) : this.getBundleClasspath(matchingBundle));
                        classpath.add(new DefaultClasspathEntry(matchingBundle.getMavenProject(), matchingBundle.getKey(), locations, null));
                        continue;
                    }
                    this.getLogger().warn("Missing extra classpath entry " + entry.trim());
                    continue;
                }
                entry = entry.trim();
                File file = new File(project.getBasedir(), entry).getAbsoluteFile();
                if (file.exists()) {
                    locations = Collections.singletonList(file);
                    ArtifactKey projectKey = this.getArtifactKey(project);
                    classpath.add(new DefaultClasspathEntry(project, projectKey, locations, null));
                    continue;
                }
                this.getLogger().warn("Missing extra classpath entry " + entry);
            }
        }
    }

    private List<File> getBundleClasspath(ArtifactDescriptor bundle) {
        LinkedHashSet<File> classpath = new LinkedHashSet<File>();
        for (String cp : this.parseBundleClasspath(bundle)) {
            File entry = ".".equals(cp) ? bundle.getLocation(true) : this.getNestedJarOrDir(bundle, cp);
            if (entry == null) continue;
            classpath.add(entry);
        }
        return new ArrayList<File>(classpath);
    }

    private List<File> getBundleEntry(ArtifactDescriptor bundle, String nestedPath) {
        LinkedHashSet<File> classpath = new LinkedHashSet<File>();
        File entry = ".".equals(nestedPath) ? bundle.getLocation(true) : this.getNestedJarOrDir(bundle, nestedPath);
        if (entry != null) {
            classpath.add(entry);
        }
        return new ArrayList<File>(classpath);
    }

    private String[] parseBundleClasspath(ArtifactDescriptor bundle) {
        OsgiManifest mf = this.bundleReader.loadManifest(bundle.getLocation(true));
        return mf.getBundleClasspath();
    }

    private File getNestedJarOrDir(ArtifactDescriptor bundle, String cp) {
        return this.bundleReader.getEntry(bundle.getLocation(true), cp);
    }

    @Override
    public TargetEnvironment getImplicitTargetEnvironment(MavenProject project) {
        String filterStr = this.getManifestValue("Eclipse-PlatformFilter", project);
        if (filterStr != null) {
            try {
                FilterImpl filter = FilterImpl.newInstance((String)filterStr);
                String ws = OsgiBundleProject.sn(filter.getPrimaryKeyValue("osgi.ws"));
                String os = OsgiBundleProject.sn(filter.getPrimaryKeyValue("osgi.os"));
                String arch = OsgiBundleProject.sn(filter.getPrimaryKeyValue("osgi.arch"));
                if (ws != null && os != null && arch != null) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("osgi.ws", ws);
                    properties.put("osgi.os", os);
                    properties.put("osgi.arch", arch);
                    if (filter.matches(properties)) {
                        return new TargetEnvironment(os, ws, arch);
                    }
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String sn(String str) {
        if (str != null && !"".equals(str.trim())) {
            return str;
        }
        return null;
    }

    @Override
    public void readExecutionEnvironmentConfiguration(ReactorProject project, MavenSession mavenSession, ExecutionEnvironmentConfiguration sink) {
        super.readExecutionEnvironmentConfiguration(project, mavenSession, sink);
        String pdeProfileName = this.getEclipsePluginProject(project).getBuildProperties().getJreCompilationProfile();
        if (pdeProfileName != null) {
            sink.setProfileConfiguration(pdeProfileName.trim(), "build.properties");
        } else {
            String[] manifestBREEs = this.getManifest(project).getExecutionEnvironments();
            if (manifestBREEs.length == 1) {
                this.applyBestOfCurrentOrConfiguredProfile(manifestBREEs[0], "Bundle-RequiredExecutionEnvironment (unique entry)", mavenSession, sink);
            } else if (manifestBREEs.length > 1) {
                TargetPlatformConfiguration tpConfiguration = TychoProjectUtils.getTargetPlatformConfiguration(project);
                switch (tpConfiguration.getBREEHeaderSelectionPolicy()) {
                    case first: {
                        this.applyBestOfCurrentOrConfiguredProfile(manifestBREEs[0], "Bundle-RequiredExecutionEnvironment (first entry)", mavenSession, sink);
                        break;
                    }
                    case minimal: {
                        Arrays.stream(manifestBREEs).map(ee -> ExecutionEnvironmentUtils.getExecutionEnvironment(ee, this.toolchainManager, mavenSession, this.logger)).sorted().findFirst().ifPresent(ee -> this.applyBestOfCurrentOrConfiguredProfile(ee.getProfileName(), "Bundle-RequiredExecutionEnvironment (minimal entry)", mavenSession, sink));
                    }
                }
            }
        }
    }

    private void applyBestOfCurrentOrConfiguredProfile(String configuredProfileName, String reason, MavenSession mavenSession, ExecutionEnvironmentConfiguration sink) {
        StandardExecutionEnvironment currentProfile;
        StandardExecutionEnvironment configuredProfile = ExecutionEnvironmentUtils.getExecutionEnvironment(configuredProfileName, this.toolchainManager, mavenSession, this.logger);
        if (configuredProfile != null) {
            sink.setProfileConfiguration(configuredProfileName, reason);
        }
        if ((currentProfile = ExecutionEnvironmentUtils.getExecutionEnvironment("JavaSE-" + Runtime.version().feature(), this.toolchainManager, mavenSession, this.logger)).compareTo(configuredProfile) > 0) {
            sink.setProfileConfiguration(currentProfile.getProfileName(), "Currently running profile, newer than configured profile (" + configuredProfileName + ") from [" + reason + "]");
        } else {
            sink.setProfileConfiguration(configuredProfileName, reason);
        }
    }
}

