/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.sisu.equinox.embedder.EmbeddedEquinox;
import org.eclipse.sisu.equinox.embedder.EquinoxLifecycleListener;
import org.eclipse.tycho.core.maven.MavenArtifactFacade;
import org.eclipse.tycho.core.shared.MavenDependenciesResolver;

@Component(role=EquinoxLifecycleListener.class, hint="MavenDependenciesResolver")
public class MavenDependenciesResolverConfigurer
extends EquinoxLifecycleListener
implements MavenDependenciesResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private LegacySupport context;
    @Requirement
    private RepositorySystem repositorySystem;

    public Collection<?> resolve(String groupId, String artifactId, String version, String packaging, String classifier, String dependencyScope) {
        Artifact artifact;
        if (classifier != null && !classifier.isEmpty()) {
            artifact = this.repositorySystem.createArtifactWithClassifier(groupId, artifactId, version, packaging, classifier);
            artifact.setScope(dependencyScope);
        } else {
            artifact = this.repositorySystem.createArtifact(groupId, artifactId, version, dependencyScope, packaging);
        }
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        MavenSession session = this.context.getSession();
        request.setOffline(session.isOffline());
        request.setLocalRepository(session.getLocalRepository());
        request.setResolveTransitively(dependencyScope != null && !dependencyScope.isEmpty());
        request.setRemoteRepositories(session.getCurrentProject().getRemoteArtifactRepositories());
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        Set artifacts = result.getArtifacts();
        ArrayList<MavenArtifactFacade> list = new ArrayList<MavenArtifactFacade>();
        for (Artifact a : artifacts) {
            list.add(new MavenArtifactFacade(a));
        }
        return list;
    }

    public void afterFrameworkStarted(EmbeddedEquinox framework) {
        framework.registerService(MavenDependenciesResolver.class, (Object)this);
    }

    public File getRepositoryRoot() {
        return new File(this.context.getSession().getLocalRepository().getBasedir());
    }
}

