/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.runtime;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.Artifact;
import org.eclipse.sisu.equinox.embedder.EquinoxRuntimeLocator;
import org.eclipse.tycho.dev.DevBundleInfo;
import org.eclipse.tycho.dev.DevWorkspaceResolver;
import org.eclipse.tycho.model.BundleConfiguration;
import org.eclipse.tycho.model.PluginRef;
import org.eclipse.tycho.model.ProductConfiguration;

class WorkspaceTychoOsgiRuntimeLocator {
    private final DevWorkspaceResolver workspaceState;
    private final File stateLocation;
    private Properties deventries = new Properties();

    private WorkspaceTychoOsgiRuntimeLocator(DevWorkspaceResolver workspaceState) {
        this.workspaceState = workspaceState;
        this.stateLocation = workspaceState.getStateLocation();
    }

    public boolean addProduct(EquinoxRuntimeLocator.EquinoxRuntimeDescription result, Artifact pom) throws MavenExecutionException {
        ProductConfiguration product;
        try {
            product = ProductConfiguration.read((File)new File(pom.getFile().getParentFile(), pom.getArtifactId() + ".product"));
        }
        catch (IOException e) {
            return false;
        }
        LinkedHashSet<String> missing = new LinkedHashSet<String>();
        for (PluginRef pluginRef : product.getPlugins()) {
            DevBundleInfo bundleInfo = this.workspaceState.getBundleInfo(pluginRef.getId(), pluginRef.getVersion());
            if (bundleInfo != null) {
                this.addBundle(result, bundleInfo);
                continue;
            }
            missing.add(pluginRef.toString());
        }
        if (!missing.isEmpty()) {
            throw new MavenExecutionException("Inconsistent m2e-tycho workspace state, missing bundles: " + ((Object)missing).toString(), (Throwable)null);
        }
        Map bundleConfigurations = product.getPluginConfiguration();
        if (bundleConfigurations != null) {
            for (BundleConfiguration bundleConfiguration : bundleConfigurations.values()) {
                result.addBundleStartLevel(bundleConfiguration.getId(), bundleConfiguration.getStartLevel(), bundleConfiguration.isAutoStart());
            }
        }
        return true;
    }

    public static WorkspaceTychoOsgiRuntimeLocator getResolver(DevWorkspaceResolver workspaceResolver) {
        if (workspaceResolver.getStateLocation() == null) {
            return null;
        }
        return new WorkspaceTychoOsgiRuntimeLocator(workspaceResolver);
    }

    public boolean addBundle(EquinoxRuntimeLocator.EquinoxRuntimeDescription result, Artifact pom) {
        DevBundleInfo bundleInfo = this.workspaceState.getBundleInfo(pom.getFile().getParentFile());
        if (bundleInfo == null) {
            return false;
        }
        this.addBundle(result, bundleInfo);
        return true;
    }

    private void addBundle(EquinoxRuntimeLocator.EquinoxRuntimeDescription result, DevBundleInfo bundleInfo) {
        result.addBundle(bundleInfo.getLocation());
        if (bundleInfo.getDevEntries() != null) {
            this.deventries.put(bundleInfo.getSymbolicName(), bundleInfo.getDevEntries());
        }
    }

    public void addPlatformProperties(EquinoxRuntimeLocator.EquinoxRuntimeDescription result) throws MavenExecutionException {
        result.addPlatformProperty("osgi.install.area", this.stateLocation.getAbsolutePath());
        File devproperties = new File(this.stateLocation, "dev.properties");
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(devproperties));){
            this.deventries.store(os, null);
            result.addPlatformProperty("osgi.dev", devproperties.toURI().toURL().toExternalForm());
        }
        catch (IOException e) {
            throw new MavenExecutionException("Could not write dev.properties", (Throwable)e);
        }
    }
}

